/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.expression;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.geotools.data.complex.feature.xpath.AttributeNodePointer;
import org.geotools.data.complex.feature.xpath.AttributeNodePointerFactory;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.xml.sax.helpers.NamespaceSupport;

public class FeaturePropertyAccessorFactory
implements PropertyAccessorFactory {
    static PropertyAccessor ATTRIBUTE_ACCESS;
    static PropertyAccessor DEFAULT_GEOMETRY_ACCESS;
    static PropertyAccessor FID_ACCESS;
    static final Pattern FID_PATTERN;

    public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
        if (SimpleFeature.class.isAssignableFrom(type)) {
            return null;
        }
        if (xpath == null) {
            return null;
        }
        if (!(ComplexAttribute.class.isAssignableFrom(type) || ComplexType.class.isAssignableFrom(type) || AttributeDescriptor.class.isAssignableFrom(type))) {
            return null;
        }
        if ("".equals(xpath)) {
            return DEFAULT_GEOMETRY_ACCESS;
        }
        if (FID_PATTERN.matcher(xpath).matches()) {
            return FID_ACCESS;
        }
        NamespaceSupport namespaces = null;
        if (hints != null) {
            namespaces = (NamespaceSupport)hints.get((Object)NAMESPACE_CONTEXT);
        }
        if (namespaces == null) {
            return ATTRIBUTE_ACCESS;
        }
        return new FeaturePropertyAccessor(namespaces);
    }

    static {
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new AttributeNodePointerFactory());
        ATTRIBUTE_ACCESS = new FeaturePropertyAccessor();
        DEFAULT_GEOMETRY_ACCESS = new DefaultGeometryFeaturePropertyAccessor();
        FID_ACCESS = new FidFeaturePropertyAccessor();
        FID_PATTERN = Pattern.compile("@(\\w+:)?id");
    }

    static class FeaturePropertyAccessor
    implements PropertyAccessor {
        private NamespaceSupport namespaces;

        public FeaturePropertyAccessor() {
            this.namespaces = new NamespaceSupport();
        }

        public FeaturePropertyAccessor(NamespaceSupport namespaces) {
            this.namespaces = namespaces;
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof Attribute || object instanceof AttributeType || object instanceof AttributeDescriptor;
        }

        public Object get(Object object, String xpath, Class target) {
            JXPathContext context = JXPathContext.newContext((Object)object);
            Enumeration<String> declaredPrefixes = this.namespaces.getDeclaredPrefixes();
            while (declaredPrefixes.hasMoreElements()) {
                String prefix = declaredPrefixes.nextElement();
                String uri = this.namespaces.getURI(prefix);
                context.registerNamespace(prefix, uri);
            }
            Iterator it = context.iteratePointers(xpath);
            ArrayList<Object> results = new ArrayList<Object>();
            while (it.hasNext()) {
                Pointer pointer = (Pointer)it.next();
                if (pointer instanceof AttributeNodePointer) {
                    results.add(((AttributeNodePointer)pointer).getImmediateAttribute());
                    continue;
                }
                results.add(pointer.getValue());
            }
            if (results.size() == 0) {
                throw new IllegalArgumentException("x-path gives no results.");
            }
            if (results.size() == 1) {
                return results.get(0);
            }
            return results;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            if (object instanceof FeatureType) {
                throw new IllegalAttributeException(null, (Object)"feature type is immutable");
            }
            JXPathContext context = JXPathContext.newContext((Object)object);
            Enumeration<String> declaredPrefixes = this.namespaces.getDeclaredPrefixes();
            while (declaredPrefixes.hasMoreElements()) {
                String prefix = declaredPrefixes.nextElement();
                String uri = this.namespaces.getURI(prefix);
                context.registerNamespace(prefix, uri);
            }
            context.setValue(xpath, value);
            assert (value == context.getValue(xpath));
        }
    }

    static class DefaultGeometryFeaturePropertyAccessor
    implements PropertyAccessor {
        DefaultGeometryFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            if (!"".equals(xpath)) {
                return false;
            }
            return object instanceof Feature || object instanceof FeatureType;
        }

        public Object get(Object object, String xpath, Class target) {
            if (object instanceof Feature) {
                return ((Feature)object).getDefaultGeometryProperty();
            }
            if (object instanceof FeatureType) {
                FeatureType ft = (FeatureType)object;
                GeometryDescriptor gd = ft.getGeometryDescriptor();
                if (gd == null) {
                    for (PropertyDescriptor pd : ft.getDescriptors()) {
                        if (!Geometry.class.isAssignableFrom(pd.getType().getBinding())) continue;
                        return pd;
                    }
                }
                return gd;
            }
            return null;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            if (object instanceof Feature) {
                Feature f = (Feature)object;
                if (value instanceof GeometryAttribute) {
                    GeometryAttribute geom = (GeometryAttribute)value;
                    f.setDefaultGeometryProperty(geom);
                } else if (value instanceof Geometry) {
                    GeometryAttribute geom = f.getDefaultGeometryProperty();
                    geom.setValue(value);
                } else {
                    throw new IllegalArgumentException("Argument is not a geometry: " + value);
                }
            }
            if (object instanceof FeatureType) {
                throw new IllegalAttributeException(null, (Object)"feature type is immutable");
            }
        }
    }

    static class FidFeaturePropertyAccessor
    implements PropertyAccessor {
        FidFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof Attribute && FID_PATTERN.matcher(xpath).matches();
        }

        public Object get(Object object, String xpath, Class target) {
            Attribute feature = (Attribute)object;
            return feature.getIdentifier().toString();
        }

        public void set(Object object, String xpath, Object value, Class target) {
            throw new IllegalAttributeException(null, value, "feature id is immutable");
        }
    }
}

