/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures.worker;

import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.opengis.feature.simple.SimpleFeature;

public class WFSFeatureUtils {
    private static Pattern pt = Pattern.compile("\\{\\{([^}]*)\\}\\}");
    private static Pattern titleColumnShouldMatchPattern = Pattern.compile(".*(TITLE|LABEL|NAME|TITRE|NOM|LIBELLE).*", 2);

    static String buildFeatureTitle(SimpleFeature feature, Map<String, String> fields, String titleExpression) {
        if (StringUtils.isNotEmpty((String)titleExpression)) {
            if (titleExpression.contains("{{")) {
                Matcher m = pt.matcher(titleExpression);
                while (m.find()) {
                    String attributeName = m.group(1);
                    String attributeValue = (String)feature.getAttribute(attributeName);
                    titleExpression = titleExpression.replaceAll("\\{\\{" + attributeName + "\\}\\}", attributeValue);
                }
                return titleExpression;
            }
            String attributeValue = (String)feature.getAttribute(titleExpression);
            if (attributeValue != null) {
                return attributeValue;
            }
            return null;
        }
        for (String attributeName : fields.keySet()) {
            String attributeType = fields.get(attributeName);
            String attributeValue = (String)feature.getAttribute(attributeName);
            if (attributeValue == null || attributeType.equals("geometry")) continue;
            return attributeValue;
        }
        return null;
    }

    static String guessFeatureTitleAttribute(Map<String, String> fields) {
        Set<String> keySet = fields.keySet();
        String defaultTitle = null;
        for (String attributeName : keySet) {
            Matcher m;
            if ("geometry".equals(fields.get(attributeName))) continue;
            if (defaultTitle == null) {
                defaultTitle = attributeName;
            }
            if (!(m = titleColumnShouldMatchPattern.matcher(attributeName)).find()) continue;
            return attributeName;
        }
        return defaultTitle;
    }
}

