/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures.worker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.jcs.access.exception.InvalidArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.fao.geonet.harvester.wfsfeatures.model.WFSHarvesterParameter;
import org.fao.geonet.harvester.wfsfeatures.worker.WFSFeatureUtils;
import org.fao.geonet.harvester.wfsfeatures.worker.WFSHarvesterExchangeState;
import org.fao.geonet.index.es.EsRestClient;
import org.geotools.data.DataSourceException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.referencing.CRS;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;
import org.opengis.temporal.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class EsWFSFeatureIndexer {
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_START_REGEX = "<!\\[CDATA\\[";
    public static final String CDATA_END = "]]>";
    private static Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.harvest.wfs.features");
    @Value(value="${es.index.features}")
    private String index = "features";
    @Value(value="${es.index.features.type}")
    private String indexType = "features";
    @Value(value="${es.index.features.featureCommitInterval:300}")
    private int featureCommitInterval;
    @Value(value="${es.index.features.applyPrecisionModel:false}")
    private boolean applyPrecisionModel;
    @Value(value="${es.index.features.numberOfDecimals:7}")
    private int numberOfDecimals;
    @Autowired
    private EsRestClient client;
    private ObjectMapper jacksonMapper = new ObjectMapper();
    private int nbOfFeatures;
    private static final String DEFAULT_FIELDSUFFIX = "_s";
    private static final String TREE_FIELD_SUFFIX = "_tree";
    private static final String FEATURE_FIELD_PREFIX = "ft_";
    private static final Map<String, String> XSDTYPES_TO_FIELD_NAME_SUFFIX;
    private Map<String, String> featureAttributeToDocumentFieldNames = new LinkedHashMap<String, String>();

    public int getFeatureCommitInterval() {
        return this.featureCommitInterval;
    }

    public void setFeatureCommitInterval(int featureCommitInterval) {
        this.featureCommitInterval = featureCommitInterval;
    }

    public boolean isApplyPrecisionModel() {
        return this.applyPrecisionModel;
    }

    public void setApplyPrecisionModel(boolean applyPrecisionModel) {
        this.applyPrecisionModel = applyPrecisionModel;
    }

    public int getNumberOfDecimals() {
        return this.numberOfDecimals;
    }

    public void setNumberOfDecimals(int numberOfDecimals) {
        this.numberOfDecimals = numberOfDecimals;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public void initialize(Exchange exchange, boolean connect) throws InvalidArgumentException {
        WFSHarvesterParameter configuration = (WFSHarvesterParameter)exchange.getProperty("configuration");
        if (configuration == null) {
            throw new InvalidArgumentException("Missing WFS harvester configuration.");
        }
        LOGGER.info("Initializing harvester configuration for uuid '{}', url '{}',feature type '{}'. treefields are {}, tokenizedFields are {} Exchange id is '{}'.", new Object[]{configuration.getMetadataUuid(), configuration.getUrl(), configuration.getTypeName(), configuration.getTreeFields(), configuration.getTokenizedFields(), exchange.getExchangeId()});
        WFSHarvesterExchangeState config = new WFSHarvesterExchangeState(configuration);
        if (connect) {
            try {
                config.initDataStore();
            }
            catch (Exception e) {
                String errorMsg = String.format("Failed to connect to server '%s'. Error is %s", configuration.getUrl(), e.getMessage());
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
        }
        exchange.setProperty("featureTypeConfig", (Object)config);
    }

    public void deleteFeatures(Exchange exchange) {
        WFSHarvesterExchangeState state = (WFSHarvesterExchangeState)exchange.getProperty("featureTypeConfig");
        String url = state.getParameters().getUrl();
        String typeName = state.getParameters().getTypeName();
        this.deleteFeatures(url, typeName, this.client);
    }

    public void deleteFeatures(String url, String typeName, EsRestClient client) {
        LOGGER.info("Deleting features previously index from service '{}' and feature type '{}' in index '{}/{}'", new Object[]{url, typeName, this.index, this.indexType});
        try {
            long begin = System.currentTimeMillis();
            client.deleteByQuery(this.index, String.format("+featureTypeId:\"%s\"", this.getIdentifier(url, typeName)));
            LOGGER.info("  Features deleted in {} ms.", (Object)(System.currentTimeMillis() - begin));
            begin = System.currentTimeMillis();
            client.deleteByQuery(this.index, String.format("+id:\"%s\"", this.getIdentifier(url, typeName)));
            LOGGER.info("  Report deleted in {} ms.", (Object)(System.currentTimeMillis() - begin));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error connecting to ES at '{}'. Error is {}.", (Object)this.index, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFeatures(Exchange exchange) throws Exception {
        WFSHarvesterExchangeState state = (WFSHarvesterExchangeState)exchange.getProperty("featureTypeConfig");
        String url = state.getParameters().getUrl();
        String typeName = state.getParameters().getTypeName();
        String resolvedTypeName = state.getResolvedTypeName();
        Map<String, String> tokenizedFields = state.getParameters().getTokenizedFields();
        WFSDataStore wfs = state.getWfsDatastore();
        Map<String, String> featureAttributes = state.getFields();
        TitleResolver titleResolver = this.getTitleResolver(state);
        LOGGER.info("Indexing WFS features from service '{}' and feature type '{}'. Precision model applied: '{}', number of decimals: '{}'", new Object[]{url, typeName, this.applyPrecisionModel, this.numberOfDecimals});
        Report report = new Report(url, typeName);
        ObjectNode protoNode = this.createProtoNode(url, typeName);
        if (state.getParameters().getMetadataUuid() != null) {
            report.put("parent", state.getParameters().getMetadataUuid());
            protoNode.put("recordGroup", state.getParameters().getMetadataUuid());
            ObjectNode linkToParent = this.jacksonMapper.createObjectNode();
            linkToParent.put("name", "feature");
            linkToParent.put("parent", state.getParameters().getMetadataUuid());
            protoNode.set("featureOfRecord", (JsonNode)linkToParent);
        }
        this.initFeatureAttributeToDocumentFieldNamesMapping(featureAttributes, state.getParameters().getTreeFields(), report);
        boolean initializeESReportSucceeded = report.saveHarvesterReport();
        if (!initializeESReportSucceeded) {
            String msg = "Couldn't initialize harvesting report, don't even try to go further querying wfs.";
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        try {
            this.nbOfFeatures = 0;
            Phaser phaser = new Phaser();
            AsyncBulkResutHandler brh = new AsyncBulkResutHandler(phaser, typeName, url, this.nbOfFeatures, report, state.getParameters().getMetadataUuid());
            long begin = System.currentTimeMillis();
            ContentFeatureCollection fc = wfs.getFeatureSource(resolvedTypeName).getFeatures();
            ReprojectingFeatureCollection rfc = new ReprojectingFeatureCollection((SimpleFeatureCollection)fc, CRS.decode((String)"urn:ogc:def:crs:OGC:1.3:CRS84"));
            try (SimpleFeatureIterator features = rfc.features();){
                while (features.hasNext()) {
                    String featurePointer = String.format("%s#%s", typeName, this.nbOfFeatures);
                    try {
                        SimpleFeature feature = null;
                        try {
                            feature = (SimpleFeature)features.next();
                            featurePointer = String.format("%s/id:%s", featurePointer, feature.getID());
                        }
                        catch (Exception e) {
                            String msg;
                            if (e.getCause() instanceof IOException || e.getCause() instanceof DataSourceException) {
                                msg = String.format("Error while getting feature %s. Exception is: %s. Harvesting task will be stopped. This is probably a problem with the data source or some network related issues. Try to relaunch it later.", featurePointer, e.getMessage());
                                LOGGER.warn(msg);
                                report.put("error_ss", msg);
                                break;
                            }
                            msg = String.format("Error on reading %s. Exception is: %s", featurePointer, e.getMessage());
                            LOGGER.warn(msg);
                            report.put("error_ss", msg);
                            continue;
                        }
                        ObjectNode rootNode = protoNode.deepCopy();
                        titleResolver.setTitle(rootNode, feature);
                        for (String attributeName : featureAttributes.keySet()) {
                            String msg;
                            Object attributeValue = feature.getAttribute(attributeName);
                            if (attributeValue == null) continue;
                            if (tokenizedFields != null && tokenizedFields.get(attributeName) != null) {
                                String rawValue = (String)attributeValue;
                                String value = rawValue.startsWith(CDATA_START) ? rawValue.replaceFirst(CDATA_START_REGEX, "").substring(0, rawValue.length() - CDATA_END.length() - CDATA_START.length()) : rawValue;
                                String separator = tokenizedFields.get(attributeName);
                                String[] tokens = value.split(separator);
                                ArrayNode arrayNode = this.jacksonMapper.createArrayNode();
                                for (String token : tokens) {
                                    arrayNode.add(token.trim());
                                }
                                rootNode.putPOJO(this.getDocumentFieldName(attributeName), (Object)arrayNode);
                                continue;
                            }
                            if (this.getDocumentFieldName(attributeName).equals("geom")) {
                                Geometry geom = (Geometry)feature.getDefaultGeometry();
                                if (this.applyPrecisionModel) {
                                    if (geom.isValid()) {
                                        PrecisionModel precisionModel = new PrecisionModel(Math.pow(10.0, this.numberOfDecimals - 1));
                                        geom = GeometryPrecisionReducer.reduce((Geometry)geom, (PrecisionModel)precisionModel);
                                    } else {
                                        msg = String.format("Feature %s: Cannot apply precision reducer on invalid geometry. Check the geometry validity. The feature will be indexed but with no geometry.", featurePointer);
                                        LOGGER.warn(msg);
                                        report.put("error_ss", msg);
                                        break;
                                    }
                                }
                                String gjson = new GeometryJSON(this.numberOfDecimals).toString(geom);
                                JsonNode jsonNode = this.jacksonMapper.readTree(gjson.getBytes(StandardCharsets.UTF_8));
                                rootNode.put(this.getDocumentFieldName(attributeName), jsonNode);
                                boolean isPoint = geom instanceof Point;
                                if (isPoint) {
                                    Coordinate point = geom.getCoordinate();
                                    rootNode.put("location", String.format("%s,%s", point.y, point.x));
                                } else {
                                    report.setPointOnlyForGeomsFalse();
                                }
                                BoundingBox bbox = feature.getBounds();
                                rootNode.put("bbox_xmin", bbox.getMinX());
                                rootNode.put("bbox_ymin", bbox.getMinY());
                                rootNode.put("bbox_xmax", bbox.getMaxX());
                                rootNode.put("bbox_ymax", bbox.getMaxY());
                                continue;
                            }
                            if (attributeValue instanceof Instant) {
                                try {
                                    rootNode.put(this.getDocumentFieldName(attributeName), ((DefaultInstant)attributeValue).getPosition().getDate().toInstant().toString());
                                }
                                catch (Exception instantException) {
                                    msg = String.format("Feature %s: Cannot read attribute %s, value %s. Exception is: %s", featurePointer, attributeName, attributeValue, instantException.getMessage());
                                    LOGGER.warn(msg);
                                    report.put("error_ss", msg);
                                }
                                continue;
                            }
                            String value = attributeValue.toString();
                            rootNode.put(this.getDocumentFieldName(attributeName), value.startsWith(CDATA_START) ? value.replaceFirst(CDATA_START_REGEX, "").substring(0, value.length() - CDATA_END.length() - CDATA_START.length()) : value);
                        }
                        ++this.nbOfFeatures;
                        brh.addAction(rootNode, feature);
                    }
                    catch (Exception ex) {
                        String msg = String.format("Feature %s: Error is: %s", featurePointer, ex.getMessage());
                        LOGGER.warn(msg);
                        report.put("error_ss", msg);
                    }
                    if (brh.getBulkSize() < this.featureCommitInterval) continue;
                    ((BulkResutHandler)brh).launchBulk(this.client);
                    brh = new AsyncBulkResutHandler(phaser, typeName, url, this.nbOfFeatures, report, state.getParameters().getMetadataUuid());
                }
            }
            if (brh.getBulkSize() > 0) {
                ((BulkResutHandler)brh).launchBulk(this.client);
            }
            try {
                if (this.nbOfFeatures > 0) {
                    phaser.awaitAdvanceInterruptibly(0, 3L, TimeUnit.HOURS);
                }
            }
            catch (TimeoutException e) {
                throw new Exception("Timeout when awaiting all bulks to be processed.");
            }
            LOGGER.info("{}: {} features processed in {} ms.", new Object[]{typeName, this.nbOfFeatures, System.currentTimeMillis() - begin});
            report.success(this.nbOfFeatures);
        }
        catch (Exception e) {
            report.put("status_s", "error");
            report.put("error_ss", e.getMessage());
            LOGGER.error(e.getMessage());
            throw e;
        }
        finally {
            report.saveHarvesterReport();
        }
    }

    private TitleResolver getTitleResolver(final WFSHarvesterExchangeState state) {
        String defaultTitleAttribute;
        final String titleExpression = state.getParameters().getTitleExpression();
        String string = defaultTitleAttribute = titleExpression == null ? WFSFeatureUtils.guessFeatureTitleAttribute(state.getFields()) : null;
        TitleResolver titleResolver = titleExpression != null ? new TitleResolver(){

            @Override
            public void setTitle(ObjectNode objectNode, SimpleFeature simpleFeature) {
                objectNode.put("resourceTitle", WFSFeatureUtils.buildFeatureTitle(simpleFeature, state.getFields(), titleExpression));
            }
        } : (defaultTitleAttribute != null ? new TitleResolver(){

            @Override
            public void setTitle(ObjectNode objectNode, SimpleFeature simpleFeature) {
                Object titleAttribute = simpleFeature.getAttribute(defaultTitleAttribute);
                if (titleAttribute != null) {
                    objectNode.put("resourceTitle", titleAttribute.toString());
                }
            }
        } : new TitleResolver(){

            @Override
            public void setTitle(ObjectNode objectNode, SimpleFeature simpleFeature) {
            }
        });
        return titleResolver;
    }

    private ObjectNode createProtoNode(String url, String typeName) {
        ObjectNode protoNode = this.jacksonMapper.createObjectNode();
        protoNode.put("docType", "feature");
        protoNode.put("resourceType", "feature");
        protoNode.put("featureTypeId", this.getIdentifier(url, typeName));
        return protoNode;
    }

    private String getIdentifier(String url, String typeName) {
        try {
            return URLEncoder.encode(url + "#" + typeName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("  Can not build an URL encoded identifier from {}#{}. Exception is {}.", new Object[]{url, typeName, e.getMessage()});
            return null;
        }
    }

    private void initFeatureAttributeToDocumentFieldNamesMapping(Map<String, String> featureAttributes, List<String> treeFields, Report report) {
        for (String attributeName : featureAttributes.keySet()) {
            String attributeType = featureAttributes.get(attributeName);
            if (attributeType.equals("geometry")) {
                this.featureAttributeToDocumentFieldNames.put(attributeName, "geom");
                continue;
            }
            boolean isTree = treeFields != null ? treeFields.contains(attributeName) : false;
            this.featureAttributeToDocumentFieldNames.put(attributeName, String.join((CharSequence)"", FEATURE_FIELD_PREFIX, attributeName, XSDTYPES_TO_FIELD_NAME_SUFFIX.get(attributeType), isTree ? TREE_FIELD_SUFFIX : ""));
        }
        report.put("ftColumns_s", Joiner.on((String)"|").join(featureAttributes.keySet()));
        report.put("docColumns_s", Joiner.on((String)"|").join(this.featureAttributeToDocumentFieldNames.values()));
    }

    private String getDocumentFieldName(String attributeName) {
        return this.featureAttributeToDocumentFieldNames.get(attributeName);
    }

    static {
        try {
            Logging.ALL.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        XSDTYPES_TO_FIELD_NAME_SUFFIX = ImmutableMap.builder().put((Object)"integer", (Object)"_ti").put((Object)"string", (Object)DEFAULT_FIELDSUFFIX).put((Object)"double", (Object)"_d").put((Object)"boolean", (Object)"_b").put((Object)"date", (Object)"_dt").put((Object)"dateTime", (Object)"_dt").build();
    }

    class AsyncBulkResutHandler
    extends BulkResutHandler {
        public AsyncBulkResutHandler(Phaser phaser, String typeName, String url, int firstFeatureIndex, Report report, String metadataUuid) {
            super(phaser, typeName, url, firstFeatureIndex, report, metadataUuid);
        }

        @Override
        public void launchBulk(EsRestClient client) throws Exception {
            this.prepareLaunch();
            client.getClient().bulkAsync(this.bulk, RequestOptions.DEFAULT, this.listener);
        }
    }

    abstract class BulkResutHandler {
        protected Phaser phaser;
        protected String typeName;
        private String url;
        protected int firstFeatureIndex;
        private Report report;
        private String metadataUuid;
        protected long begin;
        protected BulkRequest bulk;
        protected int bulkSize;
        protected int failuresCount;
        ActionListener<BulkResponse> listener;

        public BulkResutHandler(final Phaser phaser, final String typeName, String url, final int firstFeatureIndex, final Report report, String metadataUuid) {
            this.phaser = phaser;
            this.typeName = typeName;
            this.url = url;
            this.firstFeatureIndex = firstFeatureIndex;
            this.report = report;
            this.metadataUuid = metadataUuid;
            this.bulk = new BulkRequest(EsWFSFeatureIndexer.this.index);
            this.bulkSize = 0;
            this.failuresCount = 0;
            LOGGER.debug("  {} - Indexing bulk (size {}) starting at {} ...", new Object[]{typeName, EsWFSFeatureIndexer.this.featureCommitInterval, firstFeatureIndex});
            this.listener = new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse bulkResponse) {
                    AtomicInteger bulkFailures = new AtomicInteger();
                    if (bulkResponse.hasFailures()) {
                        Arrays.stream(bulkResponse.getItems()).forEach(e -> {
                            if (e.status() != RestStatus.OK && e.status() != RestStatus.CREATED) {
                                String msg = String.format("Feature %s: Indexing error. Error is: %s", e.getId(), e.getFailure().toString());
                                report.put("error_ss", msg);
                                LOGGER.warn(msg);
                                bulkFailures.getAndIncrement();
                            }
                        });
                    }
                    LOGGER.debug("  {} - Features [{}-{}] indexed in {} ms{}.", new Object[]{typeName, firstFeatureIndex, firstFeatureIndex + BulkResutHandler.this.bulkSize, System.currentTimeMillis() - BulkResutHandler.this.begin, bulkResponse.hasFailures() ? " but with " + bulkFailures + " errors" : ""});
                    BulkResutHandler.this.failuresCount = bulkFailures.get();
                    phaser.arriveAndDeregister();
                }

                public void onFailure(Exception e) {
                    String msg = String.format("Features [%s-%s] indexed in %s ms but with errors. Exception: %s", typeName, firstFeatureIndex, BulkResutHandler.this.bulkSize, System.currentTimeMillis() - BulkResutHandler.this.begin, e.getMessage());
                    report.put("error_ss", msg);
                    LOGGER.error(msg);
                    phaser.arriveAndDeregister();
                }
            };
        }

        public int getBulkSize() {
            return this.bulkSize;
        }

        public int getNumberOfIndexedFeatures() {
            return this.bulkSize - this.failuresCount;
        }

        public void addAction(ObjectNode rootNode, SimpleFeature feature) throws JsonProcessingException {
            String featureId = feature.getID();
            if (featureId.toLowerCase().indexOf("placeholder") > -1) {
                featureId = "fid-" + EsWFSFeatureIndexer.this.nbOfFeatures;
            }
            String id = String.format("%s#%s#%s", this.url, this.typeName, featureId);
            this.bulk.add(new IndexRequest(EsWFSFeatureIndexer.this.index).id(id).source(EsWFSFeatureIndexer.this.jacksonMapper.writeValueAsString((Object)rootNode), XContentType.JSON));
            ++this.bulkSize;
        }

        protected void prepareLaunch() {
            this.phaser.register();
            this.begin = System.currentTimeMillis();
        }

        public abstract void launchBulk(EsRestClient var1) throws Exception;
    }

    class Report {
        private Map<String, Object> report = new HashMap<String, Object>();
        private String url;
        private String typeName;
        private boolean pointOnlyForGeoms;

        public Report(String url, String typeName) throws UnsupportedEncodingException {
            this.typeName = typeName;
            this.url = url;
            this.pointOnlyForGeoms = true;
            this.report.put("id", EsWFSFeatureIndexer.this.getIdentifier(url, typeName));
            this.report.put("docType", "harvesterReport");
        }

        public void put(String key, Object value) {
            this.report.put(key, value);
        }

        public void setPointOnlyForGeomsFalse() {
            this.pointOnlyForGeoms = false;
        }

        public void success(int nbOfFeatures) {
            this.report.put("status_s", "success");
            this.report.put("totalRecords_i", nbOfFeatures);
            OffsetDateTime dateTime = OffsetDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS);
            this.report.put("endDate_dt", dateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            this.report.put("isPointOnly", this.pointOnlyForGeoms);
        }

        public boolean saveHarvesterReport() {
            IndexRequest request = new IndexRequest(EsWFSFeatureIndexer.this.index);
            request.id(this.report.get("id").toString());
            request.source(this.report);
            try {
                IndexResponse response = EsWFSFeatureIndexer.this.client.getClient().index(request, RequestOptions.DEFAULT);
                if (response.status() == RestStatus.CREATED || response.status() == RestStatus.OK) {
                    LOGGER.info("Report saved for service {} and typename {}. Report id is {}", new Object[]{this.url, this.typeName, this.report.get("id")});
                } else {
                    LOGGER.info("Failed to save report for {}. Error was '{}'.", (Object)this.typeName, (Object)response.getResult());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }

    static interface TitleResolver {
        public void setTitle(ObjectNode var1, SimpleFeature var2);
    }
}

