/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataDataInfo_;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataDraft_;
import org.fao.geonet.domain.MetadataSourceInfo;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.repository.MetadataDraftRepositoryCustom;
import org.fao.geonet.repository.SimpleMetadata;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.reports.MetadataReportsQueries;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public class MetadataDraftRepositoryCustomImpl
implements MetadataDraftRepositoryCustom<MetadataDraft> {
    @PersistenceContext
    EntityManager _entityManager;

    @Override
    public MetadataReportsQueries getMetadataReports() {
        return new MetadataReportsQueries(this._entityManager);
    }

    @Override
    @Nonnull
    public Page<Pair<Integer, ISODate>> findIdsAndChangeDates(@Nullable Pageable pageable) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(Tuple.class);
        Root root = cbQuery.from(MetadataDraft.class);
        cbQuery.multiselect(new Selection[]{cb.count((Expression)root)});
        Long total = (Long)((Tuple)this._entityManager.createQuery(cbQuery).getSingleResult()).get(0);
        cbQuery.multiselect(new Selection[]{root.get(MetadataDraft_.id), root.get(MetadataDraft_.dataInfo).get(MetadataDataInfo_.changeDate)});
        if (pageable != null && pageable.getSort() != null) {
            Sort sort = pageable.getSort();
            List<Order> orders = SortUtils.sortToJpaOrders(cb, sort, root);
            cbQuery.orderBy(orders);
        }
        TypedQuery query = this._entityManager.createQuery(cbQuery);
        if (pageable != null) {
            query.setFirstResult(Math.toIntExact(pageable.getOffset()));
            query.setMaxResults(pageable.getPageSize());
        }
        ArrayList<Pair<Integer, ISODate>> finalResults = new ArrayList<Pair<Integer, ISODate>>();
        for (Tuple tuple : query.getResultList()) {
            Integer mdId = (Integer)tuple.get(0);
            ISODate changeDate = (ISODate)tuple.get(1);
            finalResults.add(Pair.read(mdId, changeDate));
        }
        return new PageImpl(finalResults, pageable, total.longValue());
    }

    @Override
    @Nonnull
    public List<Integer> findIdsBy(@Nonnull Specification<MetadataDraft> spec) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(Integer.class);
        Root root = cbQuery.from(MetadataDraft.class);
        cbQuery.select((Selection)root.get(MetadataDraft_.id));
        cbQuery.where((Expression)spec.toPredicate(root, cbQuery, cb));
        return this._entityManager.createQuery(cbQuery).getResultList();
    }

    @Override
    public Map<Integer, MetadataSourceInfo> findSourceInfo(Specification<MetadataDraft> spec) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(Object[].class);
        Root root = cbQuery.from(MetadataDraft.class);
        cbQuery.select((Selection)cb.array(new Selection[]{root.get(MetadataDraft_.id), root.get(MetadataDraft_.sourceInfo)}));
        cbQuery.where((Expression)spec.toPredicate(root, cbQuery, cb));
        HashMap results = Maps.newHashMap();
        List resultList = this._entityManager.createQuery(cbQuery).getResultList();
        for (Object[] objects : resultList) {
            Integer metadataId = (Integer)objects[0];
            MetadataSourceInfo sourceInfo = (MetadataSourceInfo)objects[1];
            results.put(metadataId, sourceInfo);
        }
        return results;
    }

    @Override
    public List<SimpleMetadata> findSimple(String id) {
        Query query = this._entityManager.createQuery("select new org.fao.geonet.repository.SimpleMetadata(id, uuid, dataInfo.changeDate, dataInfo.type_JPAWorkaround) from Metadata where harvestInfo.uuid = :id").setParameter("id", (Object)id);
        return query.getResultList();
    }

    @Override
    public Element findUuidsAndChangeDatesAndSchemaId(List<Integer> ids, @Nonnull Pageable pageable) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(Tuple.class);
        Root root = cbQuery.from(MetadataDraft.class);
        cbQuery.multiselect(new Selection[]{root.get(MetadataDraft_.uuid), root.get(MetadataDraft_.dataInfo).get(MetadataDataInfo_.changeDate), root.get(MetadataDraft_.dataInfo).get(MetadataDataInfo_.schemaId)});
        cbQuery.where(new Predicate[]{root.get(MetadataDraft_.id).in(ids), cb.equal((Expression)root.get(MetadataDraft_.dataInfo).get(MetadataDataInfo_.type_JPAWorkaround), (Object)Character.valueOf('n'))});
        if (pageable != null && pageable.getSort() != null) {
            Sort sort = pageable.getSort();
            List<Order> orders = SortUtils.sortToJpaOrders(cb, sort, root);
            cbQuery.orderBy(orders);
        }
        TypedQuery query = this._entityManager.createQuery(cbQuery);
        if (pageable != null) {
            query.setFirstResult(Math.toIntExact(pageable.getOffset()));
            query.setMaxResults(pageable.getPageSize());
        }
        Element result = new Element("metadata");
        for (Tuple tuple : query.getResultList()) {
            Element record = new Element("record");
            Element uuid = new Element("uuid");
            Element schemaid = new Element("schemaid");
            Element changedate = new Element("changedate");
            uuid.addContent((String)tuple.get(0));
            changedate.addContent(((ISODate)tuple.get(1)).toString());
            schemaid.addContent((String)tuple.get(2));
            record.addContent((Content)uuid);
            record.addContent((Content)changedate);
            record.addContent((Content)schemaid);
            result.addContent((Content)record);
        }
        return result;
    }

    @Override
    public Element findUuidsAndChangeDatesAndSchemaId(List<Integer> ids) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(Tuple.class);
        Root root = cbQuery.from(MetadataDraft.class);
        cbQuery.multiselect(new Selection[]{root.get(MetadataDraft_.uuid), root.get(MetadataDraft_.dataInfo).get(MetadataDataInfo_.changeDate), root.get(MetadataDraft_.dataInfo).get(MetadataDataInfo_.schemaId)});
        cbQuery.where(new Predicate[]{root.get(MetadataDraft_.id).in(ids), cb.equal((Expression)root.get(MetadataDraft_.dataInfo).get(MetadataDataInfo_.type_JPAWorkaround), (Object)Character.valueOf('n'))});
        TypedQuery query = this._entityManager.createQuery(cbQuery);
        Element result = new Element("metadata");
        for (Tuple tuple : query.getResultList()) {
            Element record = new Element("record");
            Element uuid = new Element("uuid");
            Element schemaid = new Element("schemaid");
            Element changedate = new Element("changedate");
            uuid.addContent((String)tuple.get(0));
            changedate.addContent(((ISODate)tuple.get(1)).toString());
            schemaid.addContent((String)tuple.get(2));
            record.addContent((Content)uuid);
            record.addContent((Content)changedate);
            record.addContent((Content)schemaid);
            result.addContent((Content)record);
        }
        return result;
    }
}

