/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

public enum Profile {
    Administrator(new Profile[0]),
    UserAdmin(Administrator),
    Reviewer(UserAdmin),
    Editor(Reviewer),
    RegisteredUser(Editor),
    Guest(RegisteredUser),
    Monitor(Administrator);

    public static final String PROFILES_ELEM_NAME = "profiles";
    private final Set<Profile> parents;

    private Profile(Profile ... parents) {
        this.parents = new HashSet<Profile>(Arrays.asList(parents));
    }

    public static boolean exists(String profile) {
        try {
            Profile.valueOf(profile);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Profile findProfileIgnoreCase(String profileName) {
        for (Profile actualProfile : Profile.values()) {
            if (!actualProfile.name().equalsIgnoreCase(profileName)) continue;
            return actualProfile;
        }
        return null;
    }

    public Set<Profile> getParents() {
        HashSet<Profile> parents = new HashSet<Profile>();
        for (Profile profile : Profile.values()) {
            if (!profile.parents.contains((Object)this)) continue;
            parents.add(profile);
        }
        return parents;
    }

    public Set<Profile> getAll() {
        HashSet<Profile> all = new HashSet<Profile>();
        all.add(this);
        for (Profile parent : this.getParents()) {
            all.addAll(parent.getAll());
        }
        return all;
    }

    public Element asElement() {
        Element elResult = new Element(PROFILES_ELEM_NAME);
        for (Profile profile : this.getAll()) {
            if (profile == Guest) continue;
            elResult.addContent((Content)new Element(profile.name()));
        }
        return elResult;
    }

    public Set<String> getAllNames() {
        HashSet<String> names = new HashSet<String>();
        for (Profile p : this.getAll()) {
            names.add(p.name());
        }
        return names;
    }
}

