/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.converter.JpaConverterJson;
import org.fao.geonet.entitylistener.AbstractEntityListenerManager;
import org.hibernate.annotations.Type;
import org.jdom.Content;
import org.jdom.Element;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="MetadataStatus", indexes={@Index(name="idx_metadatastatus_metadataid", columnList="metadataid"), @Index(name="idx_metadatastatus_statusid", columnList="statusid"), @Index(name="idx_metadatastatus_userid", columnList="userid"), @Index(name="idx_metadatastatus_owner", columnList="owner"), @Index(name="idx_metadatastatus_changedate", columnList="changedate")})
@EntityListeners(value={EntityListener.class})
@SequenceGenerator(name="metadataStatus_id_seq", initialValue=100, allocationSize=1)
public class MetadataStatus
extends GeonetEntity {
    public static final String ID_SEQ_NAME = "metadataStatus_id_seq";
    public static final String TABLE_NAME = "MetadataStatus";
    public static final String ID_COLUMN_NAME = "id";
    public static final String CHANGE_DATE_COLUMN_NAME = "changeDate";
    public static final String DUE_DATE_COLUMN_NAME = "dueDate";
    public static final String CLOSE_DATE_COLUMN_NAME = "closeDate";
    public static final String METADATA_ID_COLUMN_NAME = "metadataId";
    public static final String STATUS_ID_COLUMN_NAME = "statusId";
    public static final String USER_ID_COLUMN_NAME = "userId";
    public static final String EL_METADATA_STATUS = "metadataStatus";
    public static final String EL_ID = "id";
    public static final String EL_STATUS_ID = "statusId";
    public static final String EL_USER_ID = "userId";
    public static final String EL_CHANGE_DATE = "changeDate";
    public static final String EL_CHANGE_MESSAGE = "changeMessage";
    public static final String EL_NAME = "name";
    private int id;
    private ISODate _changedate;
    private int metadataId;
    private int userId;
    private String changeMessage;
    private StatusValue statusValue;
    private int _owner;
    private ISODate _duedate;
    private ISODate _closedate;
    private String previousState;
    private String currentState;
    private MetadataStatus relatedMetadataStatus;
    private String uuid;
    private LinkedHashMap<String, String> titles;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="metadataStatus_id_seq")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @AttributeOverride(name="dateAndTimeUtc", column=@Column(name="changeDate", nullable=false, length=30))
    public ISODate getChangeDate() {
        return this._changedate;
    }

    public void setChangeDate(ISODate changedate) {
        this._changedate = changedate;
    }

    @Column(name="metadataId", nullable=false)
    public int getMetadataId() {
        return this.metadataId;
    }

    public void setMetadataId(int metadataId) {
        this.metadataId = metadataId;
    }

    @Column(name="userId", nullable=false)
    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    @Column(length=2048, nullable=false)
    public String getChangeMessage() {
        return this.changeMessage;
    }

    public void setChangeMessage(String changeMessage) {
        this.changeMessage = changeMessage;
    }

    @Column(nullable=false)
    public Integer getOwner() {
        return this._owner;
    }

    public MetadataStatus setOwner(Integer ownerId) {
        if (ownerId != null) {
            this._owner = ownerId;
        }
        return this;
    }

    @AttributeOverride(name="dateAndTimeUtc", column=@Column(name="dueDate", nullable=true, length=30))
    public ISODate getDueDate() {
        return this._duedate;
    }

    public MetadataStatus setDueDate(ISODate duedate) {
        this._duedate = duedate;
        return this;
    }

    @AttributeOverride(name="dateAndTimeUtc", column=@Column(name="closeDate", nullable=true, length=30))
    public ISODate getCloseDate() {
        return this._closedate;
    }

    public MetadataStatus setCloseDate(ISODate closedate) {
        this._closedate = closedate;
        return this;
    }

    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="statusId", columnDefinition="integer", nullable=false, referencedColumnName="id")
    public StatusValue getStatusValue() {
        return this.statusValue;
    }

    public void setStatusValue(StatusValue statusValue) {
        this.statusValue = statusValue;
    }

    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="relatedMetadataStatusId", columnDefinition="integer", nullable=true, referencedColumnName="id")
    @JsonProperty(value="relatedMetadataStatusId")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public MetadataStatus getRelatedMetadataStatus() {
        return this.relatedMetadataStatus;
    }

    public void setRelatedMetadataStatus(MetadataStatus relatedMetadataStatus) {
        this.relatedMetadataStatus = relatedMetadataStatus;
    }

    @Column(nullable=false)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(@Nonnull String uuid) {
        this.uuid = uuid;
    }

    @Transient
    public LinkedHashMap<String, String> getTitles() {
        return this.titles;
    }

    @Column(name="titles")
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Basic(fetch=FetchType.LAZY)
    @JsonProperty(value="titles")
    @JsonRawValue
    @Deprecated
    public String getTitlesString() {
        JpaConverterJson jpaConverterJson = new JpaConverterJson();
        return jpaConverterJson.convertToDatabaseColumn(this.getTitles());
    }

    @Deprecated
    public void setTitlesString(String titles) {
        this.setTitles(titles);
    }

    public void setTitles(LinkedHashMap<String, String> titles) {
        this.titles = titles;
    }

    public void setTitles(String titles) {
        if (titles != null) {
            JpaConverterJson jpaConverterJson = new JpaConverterJson();
            this.titles = (LinkedHashMap)jpaConverterJson.convertToEntityAttribute(titles);
        }
    }

    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Basic(fetch=FetchType.LAZY)
    public String getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(String previousState) {
        this.previousState = previousState;
    }

    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Basic(fetch=FetchType.LAZY)
    public String getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    @Transient
    public Element getAsXml() {
        return new Element(EL_METADATA_STATUS).addContent((Content)new Element("id").setText(String.valueOf(this.getId()))).addContent((Content)new Element("statusId").setText(String.valueOf(this.getStatusValue().getId()))).addContent((Content)new Element("userId").setText(String.valueOf(this.getUserId()))).addContent((Content)new Element("changeDate").setText(this.getChangeDate().getDateAndTime())).addContent((Content)new Element(EL_CHANGE_MESSAGE).setText(this.getChangeMessage())).addContent((Content)new Element(EL_NAME).setText(this.getStatusValue().getName()));
    }

    public String toString() {
        return "MetadataStatus [id=" + this.id + ", _metadataId=" + this.metadataId + ", _statusId=" + this.statusValue.getId() + ", _userId=" + this.userId + ", " + (this._changedate != null ? "changeDate=" + this.getChangeDate().getDateAndTime() + ", " : "") + (this.uuid != null ? "uuid=" + this.uuid + ", " : "") + (this.changeMessage != null ? "changeMessage=" + this.changeMessage + ", " : "") + (this.statusValue != null ? "statusValue=" + this.statusValue + ", " : "") + "_owner=" + this._owner + ", " + (this._duedate != null ? "_duedate=" + this._duedate + ", " : "") + (this._closedate != null ? "_closedate=" + this._closedate + ", " : "") + (this.previousState != null ? "previousState=" + this.previousState + ", " : "") + (this.currentState != null ? "currentState=" + this.currentState : "") + (this.relatedMetadataStatus != null ? "relatedMetadataStatusId=" + this.relatedMetadataStatus.getId() : "") + "]";
    }

    public static class EntityListener
    extends AbstractEntityListenerManager<MetadataStatus> {
    }
}

