/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.SystemConfigHandler;
import org.openrdf.sesame.config.handlers.SystemConfigFileHandler;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class ConfigServlet
extends SesameServlet {
    private SystemConfigHandler _configHandler;

    protected void _init(ServletConfig config) throws ServletException {
        String sysConfigHandler;
        SesameServer.setDefaultLogFile(null);
        String baseDir = config.getServletContext().getRealPath("");
        SesameServer.setBaseDir(new File(baseDir));
        ThreadLog.trace((String)("baseDir = " + baseDir));
        String saxDriver = this.getInitParameter("org.xml.sax.driver");
        if (saxDriver != null) {
            System.setProperty("org.xml.sax.driver", saxDriver);
        }
        if ((sysConfigHandler = this.getInitParameter("systemConfigHandler")) == null) {
            String msg = "init-param 'systemConfigHandler' not defined; please specify full classname of SystemConfigHandler implementation.";
            ThreadLog.error((String)msg);
            throw new UnavailableException(msg);
        }
        try {
            Class<?> configHandlerClass = Class.forName(sysConfigHandler);
            this._configHandler = (SystemConfigHandler)configHandlerClass.newInstance();
            HashMap<String, String> configParameters = new HashMap<String, String>();
            Iterator iter = this._configHandler.getParameterNames().iterator();
            while (iter.hasNext()) {
                String paramName = (String)iter.next();
                String paramValue = this.getInitParameter(paramName);
                if (paramValue != null) {
                    configParameters.put(paramName, paramValue);
                    continue;
                }
                String msg = "init-param '" + paramName + "' not defined. This parameter must be defined when using " + sysConfigHandler + ".";
                ThreadLog.error((String)msg);
                throw new UnavailableException(msg);
            }
            this._configHandler.setParameters(configParameters);
        }
        catch (ClassNotFoundException e) {
            ThreadLog.error((String)"SystemConfigHandler class not found", (Object)e);
            throw new UnavailableException(e.getMessage());
        }
        catch (Exception e) {
            ThreadLog.error((String)"Unable to create configuration handler", (Object)e);
            throw new UnavailableException(e.getMessage());
        }
        try {
            SystemConfig sysConfig = this._configHandler.loadConfig();
            SesameServer.setSystemConfig(sysConfig);
        }
        catch (Exception e) {
            ThreadLog.error((String)"Unable to load system config", (Object)e);
        }
        SesameServer.createLocalService();
        SesameServer.setDefaultLogFile("general.log");
        try {
            HttpServerUtil.setTmpDir((File)SesameServer.getLocalService().getTmpDir());
        }
        catch (IOException e) {
            ThreadLog.warning((String)"Unable to set tmp dir for request parameter values, using default java tmp dir", (Object)e);
        }
    }

    protected void _destroy() {
        ThreadLog.trace((String)"ConfigServlet: Clearing SesameServer");
        SesameServer.clear();
        ThreadLog.trace((String)"SesameServer cleared");
        SesameServer.unsetDefaultLogFile();
    }

    protected void _doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._handleFormURLEncodedRequest(request, response);
    }

    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (HttpServerUtil.isMultipartFormRequest((HttpServletRequest)request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String action = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"action");
        String password = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"password");
        String config = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"config");
        this._handleRequest(request, response, action, password, config);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest((HttpServletRequest)request);
        String action = HttpServerUtil.getParameter((Map)fileItemMap, (String)"action");
        String password = HttpServerUtil.getParameter((Map)fileItemMap, (String)"password");
        String config = HttpServerUtil.getParameter((Map)fileItemMap, (String)"config");
        this._handleRequest(request, response, action, password, config);
    }

    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String action, String password, String config) throws IOException {
        SesameServer.setThreadLogFile("config.log");
        this._logIP(request);
        ThreadLog.trace((String)("action = " + action));
        ThreadLog.trace((String)("password set = " + (password != null)));
        ThreadLog.trace((String)("config set = " + (config != null)));
        if (action == null) {
            this._sendBadRequest("No action specified", response);
            return;
        }
        if (!(action.equals("getConfig") || action.equals("setConfig") || action.equals("sys-refresh"))) {
            this._sendBadRequest("Unknown action specified: " + action, response);
            return;
        }
        if (action.equals("setConfig") && config == null) {
            this._sendBadRequest("'config' parameter is missing", response);
            return;
        }
        String adminPassword = SesameServer.getSystemConfig().getAdminPassword();
        if (adminPassword != null && adminPassword.trim().length() > 0 && !adminPassword.equals(password)) {
            if (password == null) {
                this._sendBadRequest("Password required", response);
            } else {
                this._sendBadRequest("Password incorrect", response);
            }
            return;
        }
        HttpServerUtil.setNoCacheHeaders((HttpServletResponse)response);
        if (action.equals("getConfig")) {
            this._sendConfig(response);
        } else if (action.equals("setConfig")) {
            this._setNewConfig(config, response);
        } else if (action.equals("sys-refresh")) {
            this._refreshSystemConfig(response);
        }
    }

    private void _sendConfig(HttpServletResponse response) throws IOException {
        try {
            ThreadLog.trace((String)"sending system configuration");
            response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            SystemConfig sysConfig = SesameServer.getSystemConfig();
            SystemConfigFileHandler.writeConfiguration(sysConfig, (OutputStream)out);
            out.close();
            ThreadLog.trace((String)"system configuration sent");
        }
        catch (Exception e) {
            this._sendInternalError("Sending of system configuration failed", e, response);
        }
    }

    private void _setNewConfig(String config, HttpServletResponse response) throws IOException {
        SystemConfig newConfig = null;
        try {
            ThreadLog.trace((String)"setting new system configuration");
            StringReader reader = new StringReader(config);
            newConfig = SystemConfigFileHandler.readConfiguration(reader);
        }
        catch (IOException e) {
            this._sendBadRequest("Unable to read received system configuration: " + e.getMessage(), response);
            return;
        }
        try {
            SesameServer.setSystemConfig(newConfig);
            this._configHandler.storeConfig(newConfig);
            ThreadLog.trace((String)"new system configuration set");
            response.setStatus(200);
            PrintWriter pw = response.getWriter();
            pw.write("System configuration successfully updated");
            pw.close();
        }
        catch (Exception e) {
            this._sendInternalError("Unable to store new system configuration", e, response);
        }
    }

    private void _refreshSystemConfig(HttpServletResponse response) throws IOException {
        try {
            ThreadLog.trace((String)"Refresing SesameServer configuration");
            SystemConfig config = this._configHandler.loadConfig();
            SesameServer.setSystemConfig(config);
            ThreadLog.trace((String)"SesameServer configuration refreshed");
            response.setStatus(200);
            PrintWriter pw = response.getWriter();
            pw.write("system configuration is refreshed");
            pw.close();
        }
        catch (Exception e) {
            this._sendInternalError("Unable to refresh system configuration", e, response);
        }
    }
}

