/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.constants.RDFFormat;

public class RdfSourceConfig
extends SailConfig {
    protected RdfSourceConfig(String className, boolean dummy) {
        super(className);
    }

    public RdfSourceConfig(String file) {
        this(file, RDFFormat.RDFXML);
    }

    public RdfSourceConfig(String file, RDFFormat dataFormat) {
        this("org.openrdf.sesame.sailimpl.memory.RdfSource", true);
        this.setFile(file);
        this.setDataFormat(dataFormat);
    }

    public void setFile(String file) {
        this.setParameter("file", file);
    }

    public String getFile() {
        return this.getParameter("file");
    }

    public void setDataFormat(RDFFormat dataFormat) {
        if (dataFormat != RDFFormat.RDFXML && dataFormat != RDFFormat.NTRIPLES && dataFormat != RDFFormat.TURTLE) {
            throw new IllegalArgumentException("Illegal value for dataFormat parameter: " + dataFormat.toString());
        }
        this.setParameter("dataFormat", dataFormat.toString());
    }

    public RDFFormat getDataFormat() {
        String dataFormatStr = this.getParameter("dataFormat");
        if (dataFormatStr != null) {
            return RDFFormat.forValue(dataFormatStr);
        }
        return null;
    }
}

