/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.SailQueryException;

public class Exists
implements BooleanExpr {
    private Query _qc;

    public Exists(Query qc) {
        this._qc = qc;
    }

    public Query getArg() {
        return this._qc;
    }

    public void getVariables(Collection variables) {
        this._qc.getVariables(variables);
    }

    public boolean isTrue(RdfSource rdfSource) throws SailQueryException {
        ExistsTester existsTester = new ExistsTester();
        this._qc.evaluate(rdfSource, existsTester);
        return existsTester.queryHasResults();
    }

    public String toString() {
        return "EXISTS(" + this._qc.toString() + ")";
    }

    private static class ExistsTester
    implements QueryAnswerListener {
        private boolean _queryHasResults = false;

        private ExistsTester() {
        }

        public boolean queryAnswer(QueryAnswer qa) {
            this._queryHasResults = true;
            return false;
        }

        public void clear() {
            this._queryHasResults = false;
        }

        public boolean queryHasResults() {
            return this._queryHasResults;
        }
    }
}

