/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.rql.model.BooleanQuery;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.IntegerConstant;
import org.openrdf.sesame.query.rql.model.Intersection;
import org.openrdf.sesame.query.rql.model.PropertyQuery;
import org.openrdf.sesame.query.rql.model.RealConstant;
import org.openrdf.sesame.query.rql.model.ResourceQuery;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class CompareTo
implements BooleanQuery {
    public static final int LT = 0;
    public static final int LE = 1;
    public static final int EQ = 2;
    public static final int GE = 3;
    public static final int GT = 4;
    public static final int NE = 5;
    protected ResourceQuery _arg1;
    protected ResourceQuery _arg2;
    protected int _operator;
    protected RdfSchemaSource _rss;

    public CompareTo(ResourceQuery arg1, int op, ResourceQuery arg2) {
        this._arg1 = arg1;
        this._arg2 = arg2;
        if (op < 0 || op > 5) {
            throw new RuntimeException("Illegal operator: " + op);
        }
        this._operator = op;
    }

    public ResourceQuery getArg1() {
        return this._arg1;
    }

    public ResourceQuery getArg2() {
        return this._arg2;
    }

    public int getOperator() {
        return this._operator;
    }

    public boolean isTrue(RdfSchemaSource rss) throws QueryEvaluationException {
        boolean result = false;
        this._rss = rss;
        ValueIterator iter1 = this._arg1.getResources(this._rss);
        if (iter1 == null) {
            throw new QueryEvaluationException(this._arg1.toString() + " has no assigned value. ");
        }
        if (!iter1.hasNext()) {
            return false;
        }
        ValueIterator iter2 = this._arg2.getResources(this._rss);
        if (iter2 == null) {
            iter1.close();
            throw new QueryEvaluationException(this._arg2.toString() + " has no assigned value. ");
        }
        if (!iter2.hasNext()) {
            return false;
        }
        if (this._arg1.returnsSet() != this._arg2.returnsSet()) {
            iter1.close();
            iter2.close();
            throw new QueryEvaluationException("Cannot compare a set with a single element: " + this.toString());
        }
        if (this._arg1.returnsSet()) {
            result = this._compareSets(iter1, iter2);
            iter1.close();
            iter2.close();
        } else {
            Value val1 = iter1.next();
            Value val2 = iter2.next();
            iter1.close();
            iter2.close();
            result = this._compareElements(val1, val2);
        }
        return result;
    }

    protected boolean _compareElements(Value val1, Value val2) {
        boolean result = false;
        if (val1 instanceof Intersection || val2 instanceof Intersection) {
            result = this._compareIntersections(val1, val2);
        } else if (this._arg1 instanceof ClassQuery && this._arg2 instanceof ClassQuery) {
            result = this._compareClasses((Resource)val1, (Resource)val2);
        } else if (this._arg1 instanceof PropertyQuery && this._arg2 instanceof PropertyQuery) {
            result = this._compareProperties((Resource)val1, (Resource)val2);
        } else if (this._arg1 instanceof RealConstant || this._arg2 instanceof RealConstant) {
            try {
                result = this._compareReals((Literal)val1, (Literal)val2);
            }
            catch (QueryEvaluationException ignore) {}
        } else if (this._arg1 instanceof IntegerConstant || this._arg2 instanceof IntegerConstant) {
            try {
                result = this._compareIntegers((Literal)val1, (Literal)val2);
            }
            catch (QueryEvaluationException ignore) {}
        } else if (val1 instanceof Literal && val2 instanceof Literal) {
            result = this._compareLiterals((Literal)val1, (Literal)val2);
        } else if (val1 instanceof Resource && val2 instanceof Resource) {
            result = this._compareUris((Resource)val1, (Resource)val2);
        }
        return result;
    }

    protected boolean _compareClasses(Resource class1, Resource class2) {
        switch (this._operator) {
            case 0: {
                return this._rss.isSubClassOf(class1, class2);
            }
            case 1: {
                return class1.equals(class2) || this._rss.isSubClassOf(class1, class2);
            }
            case 2: {
                return class1.equals(class2);
            }
            case 3: {
                return class1.equals(class2) || this._rss.isSubClassOf(class2, class1);
            }
            case 4: {
                return this._rss.isSubClassOf(class2, class1);
            }
            case 5: {
                return !class1.equals(class2);
            }
        }
        return false;
    }

    protected boolean _compareProperties(Resource prop1, Resource prop2) {
        switch (this._operator) {
            case 0: {
                return this._rss.isSubPropertyOf(prop1, prop2);
            }
            case 1: {
                return prop1.equals(prop2) || this._rss.isSubPropertyOf(prop1, prop2);
            }
            case 2: {
                return prop1.equals(prop2);
            }
            case 3: {
                return prop1.equals(prop2) || this._rss.isSubPropertyOf(prop2, prop1);
            }
            case 4: {
                return this._rss.isSubPropertyOf(prop2, prop1);
            }
            case 5: {
                return !prop1.equals(prop2);
            }
        }
        return false;
    }

    protected boolean _compareReals(Literal arg1, Literal arg2) throws QueryEvaluationException {
        try {
            float floatVal1 = Float.parseFloat(arg1.getLabel());
            float floatVal2 = Float.parseFloat(arg2.getLabel());
            switch (this._operator) {
                case 0: {
                    return floatVal1 < floatVal2;
                }
                case 1: {
                    return floatVal1 <= floatVal2;
                }
                case 2: {
                    return floatVal1 == floatVal2;
                }
                case 3: {
                    return floatVal1 >= floatVal2;
                }
                case 4: {
                    return floatVal1 > floatVal2;
                }
                case 5: {
                    return floatVal1 != floatVal2;
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new QueryEvaluationException("argument not a float");
        }
        return false;
    }

    protected boolean _compareIntegers(Literal arg1, Literal arg2) throws QueryEvaluationException {
        try {
            int intVal1 = Integer.parseInt(arg1.getLabel());
            int intVal2 = Integer.parseInt(arg2.getLabel());
            switch (this._operator) {
                case 0: {
                    return intVal1 < intVal2;
                }
                case 1: {
                    return intVal1 <= intVal2;
                }
                case 2: {
                    return intVal1 == intVal2;
                }
                case 3: {
                    return intVal1 >= intVal2;
                }
                case 4: {
                    return intVal1 > intVal2;
                }
                case 5: {
                    return intVal1 != intVal2;
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new QueryEvaluationException("argument not an integer");
        }
        return false;
    }

    protected boolean _compareLiterals(Literal lit1, Literal lit2) {
        try {
            return this._compareIntegers(lit1, lit2);
        }
        catch (QueryEvaluationException notAnInteger) {
            try {
                return this._compareReals(lit1, lit2);
            }
            catch (QueryEvaluationException notAReal) {
                switch (this._operator) {
                    case 0: {
                        return lit1.compareTo((Object)lit2) < 0;
                    }
                    case 1: {
                        return lit1.compareTo((Object)lit2) <= 0;
                    }
                    case 2: {
                        return lit1.compareTo((Object)lit2) == 0;
                    }
                    case 3: {
                        return lit1.compareTo((Object)lit2) >= 0;
                    }
                    case 4: {
                        return lit1.compareTo((Object)lit2) > 0;
                    }
                    case 5: {
                        return lit1.compareTo((Object)lit2) != 0;
                    }
                }
                return false;
            }
        }
    }

    protected boolean _compareUris(Resource uri1, Resource uri2) {
        switch (this._operator) {
            case 2: {
                return uri1.equals(uri2);
            }
            case 5: {
                return !uri1.equals(uri2);
            }
        }
        return false;
    }

    protected boolean _compareSets(ValueIterator iter1, ValueIterator iter2) throws QueryEvaluationException {
        HashSet<Value> set1 = new HashSet<Value>();
        while (iter1.hasNext()) {
            set1.add(iter1.next());
        }
        HashSet<Value> set2 = new HashSet<Value>();
        while (iter2.hasNext()) {
            set2.add(iter2.next());
        }
        switch (this._operator) {
            case 0: {
                return set1.size() < set2.size() && set2.containsAll(set1);
            }
            case 1: {
                return set2.containsAll(set1);
            }
            case 2: {
                return ((Object)set1).equals(set2);
            }
            case 3: {
                return set1.containsAll(set2);
            }
            case 4: {
                return set1.size() > set2.size() && set1.containsAll(set2);
            }
            case 5: {
                return !((Object)set1).equals(set2);
            }
        }
        return false;
    }

    protected boolean _compareIntersections(Value val1, Value val2) {
        HashSet<Value> set2;
        HashSet<Value> set1;
        if (val1 instanceof Intersection) {
            set1 = ((Intersection)val1).getMembers();
        } else {
            set1 = new HashSet<Value>();
            set1.add(val1);
        }
        if (val2 instanceof Intersection) {
            set2 = ((Intersection)val2).getMembers();
        } else {
            set2 = new HashSet<Value>();
            set2.add(val2);
        }
        switch (this._operator) {
            case 0: {
                return this._intersectionLowerThan(set1, set2);
            }
            case 1: {
                return this._intersectionLowerEqualThan(set1, set2);
            }
            case 2: {
                return this._intersectionEqualTo(set1, set2);
            }
            case 3: {
                return this._intersectionGreaterEqualThan(set1, set2);
            }
            case 4: {
                return this._intersectionGreaterThan(set1, set2);
            }
            case 5: {
                return !this._intersectionEqualTo(set1, set2);
            }
        }
        return false;
    }

    protected boolean _intersectionEqualTo(Set set1, Set set2) {
        return ((Object)set1).equals(set2);
    }

    protected boolean _intersectionLowerEqualThan(Set set1, Set set2) {
        if (set1.containsAll(set2)) {
            return true;
        }
        HashSet difference = new HashSet(set2);
        difference.removeAll(set1);
        Iterator diffIter = difference.iterator();
        while (diffIter.hasNext()) {
            boolean subClassInSet = false;
            Resource classResource = (Resource)diffIter.next();
            StatementIterator subClassIter = this._rss.getSubClassOf(null, classResource);
            while (!subClassInSet && subClassIter.hasNext()) {
                Resource subClass = subClassIter.next().getSubject();
                if (!set1.contains(subClass)) continue;
                subClassInSet = true;
            }
            subClassIter.close();
            if (subClassInSet) continue;
            return false;
        }
        return true;
    }

    protected boolean _intersectionLowerThan(Set set1, Set set2) {
        return !this._intersectionEqualTo(set1, set2) && this._intersectionLowerEqualThan(set1, set2);
    }

    protected boolean _intersectionGreaterEqualThan(Set set1, Set set2) {
        return this._intersectionLowerEqualThan(set2, set1);
    }

    protected boolean _intersectionGreaterThan(Set set1, Set set2) {
        return this._intersectionLowerThan(set2, set1);
    }

    public String getQuery() {
        return this.toString();
    }

    public String toString() {
        String op = null;
        switch (this._operator) {
            case 0: {
                op = " < ";
                break;
            }
            case 1: {
                op = " <= ";
                break;
            }
            case 2: {
                op = " = ";
                break;
            }
            case 3: {
                op = " >= ";
                break;
            }
            case 4: {
                op = " > ";
                break;
            }
            case 5: {
                op = " != ";
            }
        }
        return this._arg1.toString() + op + this._arg2.toString();
    }
}

