/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.http;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.fcgi.client.http.HttpConnectionOverFCGI;
import org.eclipse.jetty.fcgi.client.http.HttpReceiverOverFCGI;
import org.eclipse.jetty.fcgi.client.http.HttpSenderOverFCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.util.Callback;

public class HttpChannelOverFCGI
extends HttpChannel {
    private final HttpConnectionOverFCGI connection;
    private final Flusher flusher;
    private final HttpSenderOverFCGI sender;
    private final HttpReceiverOverFCGI receiver;
    private final FCGIIdleTimeout idle;
    private int request;
    private HttpVersion version;

    public HttpChannelOverFCGI(HttpConnectionOverFCGI connection, Flusher flusher, long idleTimeout) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.flusher = flusher;
        this.sender = new HttpSenderOverFCGI(this);
        this.receiver = new HttpReceiverOverFCGI(this);
        this.idle = new FCGIIdleTimeout(connection, idleTimeout);
    }

    protected int getRequest() {
        return this.request;
    }

    void setRequest(int request) {
        this.request = request;
    }

    protected HttpSender getHttpSender() {
        return this.sender;
    }

    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public boolean isFailed() {
        return this.sender.isFailed() || this.receiver.isFailed();
    }

    void receive() {
        this.connection.process();
    }

    public void send(HttpExchange exchange) {
        this.version = exchange.getRequest().getVersion();
        this.idle.onOpen();
        this.sender.send(exchange);
    }

    public void release() {
        this.connection.release(this);
    }

    protected boolean responseBegin(int code, String reason) {
        this.idle.notIdle();
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        exchange.getResponse().version(this.version).status(code).reason(reason);
        return this.receiver.responseBegin(exchange);
    }

    protected boolean responseHeader(HttpField field) {
        HttpExchange exchange = this.getHttpExchange();
        return exchange != null && this.receiver.responseHeader(exchange, field);
    }

    protected boolean responseHeaders() {
        this.idle.notIdle();
        HttpExchange exchange = this.getHttpExchange();
        return exchange != null && this.receiver.responseHeaders(exchange);
    }

    protected boolean content(ByteBuffer buffer, Callback callback) {
        this.idle.notIdle();
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            return this.receiver.responseContent(exchange, buffer, callback);
        }
        callback.succeeded();
        return false;
    }

    protected boolean responseSuccess() {
        HttpExchange exchange = this.getHttpExchange();
        return exchange != null && this.receiver.responseSuccess(exchange);
    }

    protected boolean responseFailure(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        return exchange != null && this.receiver.responseFailure(failure);
    }

    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        this.idle.onClose();
        HttpFields responseHeaders = result.getResponse().getHeaders();
        if (result.isFailed()) {
            this.connection.close(result.getFailure());
        } else if (!this.connection.closeByHTTP(responseHeaders)) {
            this.release();
        }
    }

    protected void flush(Generator.Result ... results) {
        this.flusher.flush(results);
    }

    private class FCGIIdleTimeout
    extends IdleTimeout {
        private final HttpConnectionOverFCGI connection;
        private boolean open;

        public FCGIIdleTimeout(HttpConnectionOverFCGI connection, long idleTimeout) {
            super(connection.getHttpDestination().getHttpClient().getScheduler());
            this.connection = connection;
            this.setIdleTimeout(idleTimeout >= 0L ? idleTimeout : connection.getEndPoint().getIdleTimeout());
        }

        public void onOpen() {
            this.open = true;
            this.notIdle();
            super.onOpen();
        }

        public void onClose() {
            super.onClose();
            this.open = false;
        }

        protected void onIdleExpired(TimeoutException timeout) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Idle timeout for request {}", (long)HttpChannelOverFCGI.this.request);
            }
            this.connection.abort(timeout);
        }

        public boolean isOpen() {
            return this.open;
        }
    }
}

