/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.decoders;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class ShortDecoder
extends AbstractDecoder
implements Decoder.Text<Short> {
    public static final ShortDecoder INSTANCE = new ShortDecoder();

    public Short decode(String s) throws DecodeException {
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse Short", (Throwable)e);
        }
    }

    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Short.parseShort(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

