/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.utils.ProxyInfoObserver;
import org.fao.geonet.utils.ProxyParams;

public class ProxyInfo {
    private static int activeReaders = 0;
    private static int activeWriters = 0;
    private final ProxyParams proxyParams = new ProxyParams();
    private List<ProxyInfoObserver> observers = new ArrayList<ProxyInfoObserver>();

    public void addObserver(ProxyInfoObserver o) {
        this.observers.add(o);
    }

    public void removeObserver(ProxyInfoObserver o) {
        this.observers.remove(o);
    }

    public void setProxyInfo(String host, int port, String username, String password) {
        this.beforeWrite();
        this.proxyParams.useProxy = false;
        if (host != null && host.trim().length() != 0 && port != 0) {
            this.proxyParams.proxyHost = host;
            this.proxyParams.proxyPort = port;
            this.proxyParams.useProxy = true;
            this.proxyParams.useProxyAuth = false;
            if (username != null && username.trim().length() != 0) {
                this.proxyParams.username = username;
                this.proxyParams.password = password;
                this.proxyParams.useProxyAuth = true;
            }
        }
        this.afterWrite();
        this.beforeRead();
        this.notifyAllObservers();
        this.afterRead();
    }

    public void notifyAllObservers() {
        for (ProxyInfoObserver o : this.observers) {
            o.update(this);
        }
    }

    public ProxyParams getProxyParams() {
        this.beforeRead();
        try {
            ProxyParams proxyParams = this.proxyParams;
            return proxyParams;
        }
        finally {
            this.afterRead();
        }
    }

    private synchronized void beforeRead() {
        while (activeWriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++activeReaders;
    }

    private synchronized void afterRead() {
        --activeReaders;
        this.notifyAll();
    }

    private synchronized void beforeWrite() {
        while (activeReaders > 0 || activeWriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++activeWriters;
    }

    private synchronized void afterWrite() {
        --activeWriters;
        this.notifyAll();
    }
}

