/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.dl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import thredds.catalog.dl.VocabTranslator;

public class Grib2toDIF
implements VocabTranslator {
    private static Grib2toDIF singleton;
    private HashMap hash = new HashMap();
    private int maxLines = 1000;
    private boolean debug = false;

    public static Grib2toDIF getInstance() throws IOException {
        if (singleton == null) {
            singleton = new Grib2toDIF(null);
        }
        return singleton;
    }

    public Grib2toDIF(String dir) throws IOException {
        String line;
        InputStream ios;
        String resourceName = "/resources/thredds/dl/GRIB2-GCMD.csv";
        if (null != dir) {
            ios = new FileInputStream(dir + resourceName);
        } else {
            Class<?> c = this.getClass();
            ios = c.getResourceAsStream(resourceName);
            if (ios == null) {
                throw new IOException("Cant find resource= " + resourceName);
            }
        }
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        String discipline = null;
        String category = null;
        String param = null;
        int maxTokens = 8;
        String[] tokens = new String[maxTokens];
        int countDiscipline = -1;
        int countCategory = 0;
        int countParam = 0;
        for (int count = 0; count < this.maxLines && (line = dataIS.readLine()) != null; ++count) {
            String difParam;
            if (this.debug) {
                System.out.println("line=  " + line);
            }
            int countTokens = 0;
            int place = 0;
            while (countTokens < maxTokens) {
                int pos = line.indexOf(44, place);
                tokens[countTokens++] = pos >= 0 ? line.substring(place, pos) : line.substring(place);
                place = pos + 1;
            }
            if (tokens[0].length() > 0) {
                discipline = tokens[0];
                ++countDiscipline;
                countCategory = -1;
                countParam = -1;
            }
            if (tokens[1].length() > 0) {
                category = tokens[1];
                ++countCategory;
                countParam = -1;
            }
            if (tokens[2].length() > 0) {
                param = tokens[2];
                ++countParam;
            }
            if ((difParam = "Earth Science > " + tokens[7]).equalsIgnoreCase("n/a")) continue;
            String gribId = "2," + countDiscipline + "," + countCategory + "," + countParam;
            this.hash.put(gribId, difParam);
            if (!this.debug) continue;
            System.out.println(" adding " + discipline + ":" + category + ":" + param + " = " + gribId + " = " + difParam);
        }
        dataIS.close();
    }

    @Override
    public String translate(String from) {
        return (String)this.hash.get(from);
    }

    public static void main(String[] args) throws IOException {
        new Grib2toDIF("C:/dev/thredds/resourcespath");
    }
}

