/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import opendap.dap.BaseType;
import opendap.dap.ClientIO;
import opendap.dap.DataReadException;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.Util;

public class DString
extends BaseType
implements ClientIO {
    private String val = "String value has not been set.";

    public DString() {
    }

    public DString(String n) {
        super(n);
    }

    public final String getValue() {
        return this.val;
    }

    public final void setValue(String newVal) {
        this.val = newVal;
    }

    public String getTypeName() {
        return "String";
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.println(" = \"" + Util.escattr(this.val) + "\";");
        } else {
            os.print("\"" + Util.escattr(this.val) + "\"");
        }
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int dap_len = source.readInt();
        if (dap_len < 0) {
            throw new DataReadException("Negative string length (dap_length: " + dap_len + ") read.");
        }
        if (dap_len > Short.MAX_VALUE) {
            throw new DataReadException("DString deserialize string length (dap_length: " + dap_len + ") to large.");
        }
        int modFour = dap_len % 4;
        int pad = modFour != 0 ? 4 - modFour : 0;
        byte[] byteArray = new byte[dap_len];
        source.readFully(byteArray, 0, dap_len);
        for (int i = 0; i < pad; ++i) {
            byte unused = source.readByte();
        }
        if (statusUI != null) {
            statusUI.incrementByteCount(4 + dap_len + pad);
        }
        try {
            this.val = new String(byteArray, 0, dap_len, "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingException("ISO8859_1 encoding not supported by this VM!");
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        try {
            byte[] byteArray = this.val.getBytes("ISO8859_1");
            sink.writeInt(byteArray.length);
            int modFour = byteArray.length % 4;
            int pad = modFour != 0 ? 4 - modFour : 0;
            sink.write(byteArray, 0, byteArray.length);
            for (int i = 0; i < pad; ++i) {
                sink.writeByte(0);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingException("ISO8859_1 encoding not supported by this VM!");
        }
    }
}

