/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class ApplicationContextRegistry
implements Registry {
    private ApplicationContext applicationContext;

    public ApplicationContextRegistry(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object answer;
        try {
            answer = this.applicationContext.getBean(name, type);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
        catch (BeanNotOfRequiredTypeException e) {
            return null;
        }
        if (answer == null) {
            return null;
        }
        try {
            return type.cast(answer);
        }
        catch (Throwable e) {
            String msg = "Found bean: " + name + " in ApplicationContext: " + this.applicationContext + " of type: " + answer.getClass().getName() + " expected type was: " + type;
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    public Object lookupByName(String name) {
        try {
            return this.applicationContext.getBean(name);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public <T> Set<T> findByType(Class<T> type) {
        Map<String, T> map = this.findByTypeWithName(type);
        return new HashSet<T>(map.values());
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, type);
    }

    public Object lookup(String name) {
        return this.lookupByName(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return this.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.findByTypeWithName(type);
    }
}

