/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.camelPeriodicProducer;

import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.quartz2.QuartzComponent;
import org.apache.camel.component.quartz2.QuartzEndpoint;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.RouteDefinition;
import org.fao.geonet.camelPeriodicProducer.MessageProducer;
import org.fao.geonet.kernel.setting.SettingManager;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MessageProducerFactory {
    private static final String NEVER = "59 59 23 31 12 ? 2099";
    @Autowired
    protected RouteBuilder routeBuilder;
    @Autowired
    protected QuartzComponent quartzComponent;
    @Autowired
    protected SettingManager settingManager;
    private static Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.harvest.wfs.features");

    @PostConstruct
    public void init() throws Exception {
        try {
            this.quartzComponent.start();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    public void registerAndStart(MessageProducer messageProducer) throws Exception {
        this.quartzComponent.createEndpoint(this.buildFrom(messageProducer.getId()));
        this.writeRoute(messageProducer);
        this.reschedule(messageProducer);
    }

    public void reschedule(MessageProducer messageProducer) throws Exception {
        String id = this.buildFrom(messageProducer.getId());
        QuartzEndpoint toReschedule = (QuartzEndpoint)this.routeBuilder.getContext().getEndpoints().stream().filter(x -> x.getEndpointKey().compareTo(id) == 0).findFirst().get();
        String msgCronExpression = messageProducer.getCronExpession() == null ? NEVER : messageProducer.getCronExpession();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(toReschedule.getTriggerKey()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)msgCronExpression)).build();
        this.quartzComponent.getScheduler().interrupt(toReschedule.getId());
        this.quartzComponent.getScheduler().rescheduleJob(toReschedule.getTriggerKey(), (Trigger)trigger);
        Optional<RouteDefinition> route = this.findRoute(messageProducer.getId());
        if (route.isPresent()) {
            this.routeBuilder.getContext().startRoute(route.get().getId());
        }
    }

    public void changeMessageAndReschedule(MessageProducer messageProducer) throws Exception {
        Optional<RouteDefinition> route = this.findRoute(messageProducer.getId());
        if (route.isPresent()) {
            this.routeBuilder.getContext().removeRouteDefinition(route.get());
        }
        this.writeRoute(messageProducer);
        this.reschedule(messageProducer);
    }

    public void destroy(Long id) throws Exception {
        Optional<RouteDefinition> route = this.findRoute(id);
        if (route.isPresent()) {
            this.routeBuilder.getContext().removeRouteDefinition(route.get());
        }
        this.routeBuilder.getContext().removeEndpoints(this.buildFrom(id));
    }

    private String buildFrom(Long id) {
        return String.format("quartz2://%s-%s", this.settingManager.getSiteId(), id);
    }

    private void writeRoute(MessageProducer messageProducer) throws Exception {
        RouteDefinition routeDefinition = (RouteDefinition)((RouteDefinition)this.routeBuilder.from(this.buildFrom(messageProducer.getId())).noAutoStartup().setBody((Expression)this.routeBuilder.constant(messageProducer.getMessage()))).to(messageProducer.getTargetUri());
        this.routeBuilder.getContext().addRouteDefinition(routeDefinition);
    }

    private Optional<RouteDefinition> findRoute(Long id) {
        return this.routeBuilder.getContext().getRouteDefinitions().stream().filter(route -> this.routeInputHasQuart2RouteIdUrl((RouteDefinition)route, id)).map(Optional::ofNullable).findFirst().orElse(Optional.empty());
    }

    private boolean routeInputHasQuart2RouteIdUrl(RouteDefinition route, Long id) {
        return route.getInputs().size() == 1 && ((FromDefinition)route.getInputs().get(0)).getUri().equalsIgnoreCase(this.buildFrom(id));
    }
}

