/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Import;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.PlaceholderScope;
import com.github.sommeri.less4j.core.compiler.stages.InitialScopeExtractor;
import com.github.sommeri.less4j.core.compiler.stages.ReferencesSolver;
import com.github.sommeri.less4j.core.compiler.stages.SingleImportSolver;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ImportsAndScopeSolver {
    private final ProblemsHandler problemsHandler;
    private final LessCompiler.Configuration configuration;
    private SingleImportSolver importsSolver;

    public ImportsAndScopeSolver(ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.problemsHandler = problemsHandler;
        this.configuration = configuration;
    }

    public IScope buildImportsAndScope(StyleSheet less, LessSource source) {
        this.importsSolver = new SingleImportSolver(this.problemsHandler, this.configuration);
        InitialScopeExtractor scopeBuilder = new InitialScopeExtractor();
        IScope scope = scopeBuilder.extractScope(less);
        List<PlaceholderScope> importsPlaceholders = scopeBuilder.getImportsPlaceholders();
        this.solveNestedImports(importsPlaceholders);
        return scope;
    }

    private void solveNestedImports(List<PlaceholderScope> importsPlaceholders) {
        for (PlaceholderScope placeholder : importsPlaceholders) {
            List<PlaceholderScope> nextLevelOfImports = this.importIntoPlaceholder(placeholder);
            if (nextLevelOfImports.isEmpty()) continue;
            this.solveNestedImports(nextLevelOfImports);
        }
    }

    private List<PlaceholderScope> importIntoPlaceholder(PlaceholderScope placeholder) {
        Import encounteredImport = (Import)placeholder.getOwner();
        ReferencesSolver referencesSolver = new ReferencesSolver(this.problemsHandler, this.configuration);
        referencesSolver.solveReferences(encounteredImport, placeholder.getParent());
        ASTCssNode importedAst = this.importsSolver.importEncountered(encounteredImport, placeholder.getOwner().getSource());
        if (importedAst != null) {
            InitialScopeExtractor importedAstScopeBuilder = new InitialScopeExtractor();
            IScope addThisIntoScopeTree = importedAstScopeBuilder.extractScope(importedAst);
            placeholder.replaceSelf(addThisIntoScopeTree);
            return importedAstScopeBuilder.getImportsPlaceholders();
        }
        placeholder.removeSelf();
        return Collections.emptyList();
    }

    public Set<LessSource> getImportedSources() {
        return this.importsSolver.getImportedSources();
    }
}

