/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions;

import java.util.Collection;
import java.util.Collections;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.regions.MetadataRegion;
import org.fao.geonet.api.regions.metadata.MetadataRegionSearchRequest;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.region.Request;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MetadataRegionDAO
extends RegionsDAO {
    public static final String CATEGORY_NAME = "metadata";
    private final GeometryFactory factory = new GeometryFactory();

    public Collection<String> getRegionCategoryIds(ServiceContext context) throws Exception {
        return Collections.singleton(CATEGORY_NAME);
    }

    public Request createSearchRequest(ServiceContext context) throws Exception {
        return new MetadataRegionSearchRequest(context, this.factory);
    }

    public Geometry getGeom(ServiceContext context, String id, boolean simplified, CoordinateReferenceSystem projection) throws Exception {
        MetadataRegion region = (MetadataRegion)this.createSearchRequest(context).id(id).get();
        if (region != null) {
            return region.getGeometry(projection);
        }
        return null;
    }

    public boolean includeInListing() {
        return false;
    }
}

