/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

public enum FormatType {
    txt("text/plain"),
    html("text/html"),
    xml("application/xml"),
    json("application/json"),
    jsonld("application/vnd.schemaorg.ld+json"),
    pdf("application/pdf"),
    testpdf("application/test-pdf");

    public final String contentType;

    private FormatType(String contentType) {
        this.contentType = contentType;
    }

    public static FormatType find(String acceptHeader) {
        if (acceptHeader != null) {
            String[] accept;
            for (String h : accept = acceptHeader.toLowerCase().split(",")) {
                for (FormatType c : FormatType.values()) {
                    if (!h.startsWith(c.contentType)) continue;
                    return c;
                }
            }
        }
        return null;
    }
}

