/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.mef;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.fao.geonet.Logger;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.exceptions.BadFormatEx;
import org.fao.geonet.kernel.mef.IMEFVisitor;
import org.fao.geonet.kernel.mef.IVisitor;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

public class MEF2Visitor
implements IVisitor {
    @Override
    public void visit(Path mefFile, IMEFVisitor v) throws Exception {
        this.handleXml(mefFile, v);
    }

    @Override
    public Element handleXml(Path mefFile, IMEFVisitor v) throws Exception {
        Element info;
        block40: {
            Logger log = Log.createLogger((String)"geonetwork.mef");
            int nbMetadata = 0;
            info = new Element("info");
            try (FileSystem zipFs = ZipUtil.openZipFs((Path)mefFile);){
                Path root = zipFs.getRootDirectories().iterator().next();
                if (IO.isEmptyDir((Path)root)) {
                    log.debug("Metadata folder is directly under the unzip temporary folder.");
                    break block40;
                }
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(root);){
                    for (Path file : paths) {
                        if (!Files.isDirectory(file, new LinkOption[0])) continue;
                        Path metadataDir = file.resolve("metadata");
                        if (IO.isEmptyDir((Path)metadataDir)) {
                            throw new BadFormatEx("Missing XML document in metadata folder " + metadataDir + " in MEF file " + mefFile + ".");
                        }
                        Path fcFile = this.getFeatureCalalogFile(file);
                        Element fc = fcFile != null ? Xml.loadFile((Path)fcFile) : null;
                        Path fileInfo = file.resolve("info.xml");
                        if (Files.exists(fileInfo, new LinkOption[0])) {
                            info = Xml.loadFile((Path)fileInfo);
                        }
                        try (DirectoryStream<Path> xmlFiles = Files.newDirectoryStream(metadataDir);){
                            v.handleMetadataFiles(xmlFiles, info, nbMetadata);
                        }
                        v.handleFeatureCat(fc, nbMetadata);
                        v.handleInfo(info, nbMetadata);
                        this.handleBin(file, v, info, nbMetadata);
                        ++nbMetadata;
                    }
                }
            }
        }
        return info;
    }

    @Override
    public void handleBin(Path file, IMEFVisitor v, Element info, int index) throws Exception {
        Throwable throwable;
        InputStream in;
        String fileName;
        Throwable throwable2;
        DirectoryStream<Path> paths;
        List pubFiles = null;
        List prvFiles = null;
        if (info.getChildren().size() != 0) {
            List tmpPrv;
            List tmpPub;
            pubFiles = tmpPub = info.getChild("public").getChildren();
            prvFiles = tmpPrv = info.getChild("private").getChildren();
        }
        Path publicFile = file.resolve("public/");
        Path privateFile = file.resolve("private/");
        if (Files.exists(publicFile, new LinkOption[0]) && pubFiles != null && pubFiles.size() != 0) {
            paths = Files.newDirectoryStream(publicFile);
            throwable2 = null;
            try {
                for (Path path : paths) {
                    fileName = path.getFileName().toString();
                    in = IO.newInputStream((Path)path);
                    throwable = null;
                    try {
                        v.handlePublicFile(fileName, MEFLib.getChangeDate(pubFiles, fileName), in, index);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (paths != null) {
                    if (throwable2 != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        paths.close();
                    }
                }
            }
        }
        if (Files.exists(privateFile, new LinkOption[0]) && prvFiles != null && prvFiles.size() != 0) {
            paths = Files.newDirectoryStream(privateFile);
            throwable2 = null;
            try {
                for (Path path : paths) {
                    fileName = path.getFileName().toString();
                    in = IO.newInputStream((Path)path);
                    throwable = null;
                    try {
                        v.handlePrivateFile(fileName, MEFLib.getChangeDate(prvFiles, fileName), in, index);
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
            }
            catch (Throwable throwable9) {
                throwable2 = throwable9;
                throw throwable9;
            }
            finally {
                if (paths != null) {
                    if (throwable2 != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                    } else {
                        paths.close();
                    }
                }
            }
        }
    }

    private Path getFeatureCalalogFile(Path file) throws IOException {
        Path tmp = null;
        Path fcRepo = file.resolve("applschema/");
        if (Files.exists(fcRepo, new LinkOption[0])) {
            Path fc = fcRepo.resolve("metadata.xml");
            if (Files.exists(fc, new LinkOption[0])) {
                tmp = fc;
            } else {
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(fcRepo);){
                    Iterator<Path> iterator = paths.iterator();
                    if (iterator.hasNext()) {
                        tmp = iterator.next();
                    }
                }
            }
        }
        return tmp;
    }
}

