/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.PrefixUrlRewrite;
import org.fao.geonet.utils.ResolverRewriteDirective;
import org.jdom.Element;

public class SchemaPluginUrlRewrite
implements ResolverRewriteDirective {
    List<PrefixUrlRewrite> rewrites = new ArrayList<PrefixUrlRewrite>();

    public SchemaPluginUrlRewrite(Element root) {
        List rewriteURIs = root.getChildren("rewriteURI", Geonet.Namespaces.OASIS_CATALOG);
        for (Element rewriteURI : rewriteURIs) {
            String prefix = rewriteURI.getAttributeValue("uriStartString");
            String replacement = rewriteURI.getAttributeValue("rewritePrefix");
            try {
                if (!Files.exists(IO.toPath((URI)new URI(replacement)), new LinkOption[0])) continue;
                this.rewrites.add(new PrefixUrlRewrite(prefix, replacement));
            }
            catch (Exception e) {
                try {
                    if (!Files.exists(IO.toPath((String)replacement, (String[])new String[0]), new LinkOption[0])) continue;
                    this.rewrites.add(new PrefixUrlRewrite(prefix, IO.toPath((String)replacement, (String[])new String[0]).toUri().toString()));
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean appliesTo(String href) {
        for (PrefixUrlRewrite rewrite : this.rewrites) {
            if (!rewrite.appliesTo(href)) continue;
            return true;
        }
        return false;
    }

    public String rewrite(String href) {
        for (PrefixUrlRewrite rewrite : this.rewrites) {
            if (!rewrite.appliesTo(href)) continue;
            return rewrite.rewrite(href);
        }
        return null;
    }

    public Object getKey() {
        return "schema_plugin_url_rewrite";
    }
}

