/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.base.Preconditions;
import com.google.common.reflect.Invokable;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.UriTemplates;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;

@Singleton
public class BindMapToStringPayload
implements MapBinder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkNotNull(postParams, (Object)"postParams");
        GeneratedHttpRequest r = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(Preconditions.checkNotNull(request, (Object)"request"));
        Invokable<?, ?> invoked = r.getInvocation().getInvokable();
        Preconditions.checkArgument((boolean)invoked.isAnnotationPresent(Payload.class), (String)"method %s must have @Payload annotation to use this binder", (Object[])new Object[]{invoked});
        String payload = ((Payload)invoked.getAnnotation(Payload.class)).value();
        if (!postParams.isEmpty()) {
            payload = Strings2.urlDecode(UriTemplates.expand(payload, postParams));
        }
        return (R)((HttpRequest.Builder)request.toBuilder().payload(payload)).build();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        throw new IllegalArgumentException("this is a map binder");
    }
}

