/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.utils.Log;

public class DateUtil {
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_NANOSECONDS;
    public static final DateTimeFormatter CATCH_ALL_DATE_TIME_FORMATTER;
    private static final String DEFAULT_DATE_TIME = "3000-01-01T00:00:00.000Z";
    private static final Pattern gsYear;
    private static final Pattern gsYearMonth;
    private static final Pattern gsYearMonthDayZ;
    private static final Pattern gsDayMonthYear;
    private static final Pattern htmlFormat;

    public static String convertToISOZuluDateTime(String stringToParse) {
        if (StringUtils.trimToNull((String)stringToParse) == null) {
            return stringToParse;
        }
        try {
            String parsedDateTime = DateUtil.parseISODateTimes(StringUtils.trim((String)stringToParse), null);
            if (parsedDateTime.equals(DEFAULT_DATE_TIME)) {
                return null;
            }
            return parsedDateTime;
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static String parseISODateTimes(String dateTimeString, String durationOrDateTimeString) {
        String odt;
        ZonedDateTime odt1;
        try {
            ZonedDateTime idt = DateUtil.parseBasicOrFullDateTime(dateTimeString);
            odt1 = idt.withZoneSameInstant(ZoneOffset.UTC);
            odt = idt.withZoneSameInstant(ZoneOffset.UTC).format(ISO_OFFSET_DATE_TIME_NANOSECONDS);
        }
        catch (Exception e) {
            Log.error("geonetwork.domain", String.format("Error parsing ISO DateTimes '%s'. Error is: %s", dateTimeString, e.getMessage()), e);
            return DEFAULT_DATE_TIME;
        }
        if (StringUtils.isBlank((String)durationOrDateTimeString)) {
            return odt;
        }
        try {
            boolean minus = false;
            if (durationOrDateTimeString.startsWith("-P")) {
                durationOrDateTimeString = durationOrDateTimeString.substring(1);
                minus = true;
            }
            if (durationOrDateTimeString.startsWith("P")) {
                String[] periodAndDurationArray = durationOrDateTimeString.split("T");
                String periodString = periodAndDurationArray[0];
                String durationString = "PT" + periodAndDurationArray[1];
                Period ip = Period.parse(periodString);
                Duration duration = Duration.parse(durationString);
                ZonedDateTime odt2 = !minus ? odt1.plus(ip).plus(duration) : odt1.minus(ip).minus(duration);
                odt = odt + "|" + odt2.toString();
            } else {
                ZonedDateTime idt = DateUtil.parseBasicOrFullDateTime(durationOrDateTimeString);
                ZonedDateTime odt2 = idt.withZoneSameInstant(ZoneOffset.UTC);
                odt = odt + "|" + odt2.toString();
            }
        }
        catch (Exception e) {
            Log.error("geonetwork.domain", "Error parsing ISO DateTimes, error: " + e.getMessage(), e);
            return odt + "|" + DEFAULT_DATE_TIME;
        }
        return odt;
    }

    public static ZonedDateTime parseBasicOrFullDateTime(String stringToParse) {
        ZonedDateTime result;
        if (stringToParse.length() == 8 && !stringToParse.startsWith("T")) {
            result = LocalDate.parse(stringToParse, DateTimeFormatter.BASIC_ISO_DATE).atStartOfDay(ZoneId.systemDefault());
        } else if (stringToParse.startsWith("T") && stringToParse.contains(":")) {
            result = DateUtil.parseTime(stringToParse);
        } else if (stringToParse.contains("T") && !stringToParse.contains(":") && !stringToParse.contains("-")) {
            result = ZonedDateTime.parse(stringToParse, DateTimeFormatter.ISO_DATE_TIME);
        } else {
            Matcher matcher = gsYearMonth.matcher(stringToParse);
            if (matcher.matches()) {
                int year = Integer.parseInt(matcher.group(1));
                int month = Integer.parseInt(matcher.group(2));
                int day = 1;
                int minute = 0;
                int hour = 0;
                int seconds = 0;
                String timezone = ZoneId.systemDefault().getId();
                if (matcher.group(4) != null) {
                    minute = Integer.parseInt(matcher.group(5));
                    hour = Integer.parseInt(matcher.group(4));
                    if (StringUtils.isNotBlank((String)matcher.group(6))) {
                        timezone = matcher.group(6);
                    }
                }
                result = DateUtil.generateDate(year, month, day, seconds, minute, hour, timezone);
            } else {
                matcher = gsYear.matcher(stringToParse);
                if (matcher.matches()) {
                    int year = Integer.parseInt(matcher.group(1));
                    int month = 1;
                    int day = 1;
                    int minute = 0;
                    int hour = 0;
                    int seconds = 0;
                    String timezone = ZoneId.systemDefault().getId();
                    if (matcher.group(3) != null) {
                        minute = Integer.parseInt(matcher.group(4));
                        hour = Integer.parseInt(matcher.group(3));
                        if (StringUtils.isNotBlank((String)matcher.group(5))) {
                            timezone = matcher.group(5);
                        }
                    }
                    result = DateUtil.generateDate(year, month, day, seconds, minute, hour, timezone);
                } else {
                    matcher = gsYearMonthDayZ.matcher(stringToParse);
                    if (matcher.matches()) {
                        int year = Integer.parseInt(matcher.group(1));
                        int month = Integer.parseInt(matcher.group(2));
                        int day = Integer.parseInt(matcher.group(3));
                        int minute = 0;
                        int hour = 0;
                        int seconds = 0;
                        String timezone = ZoneId.systemDefault().getId();
                        result = DateUtil.generateDate(year, month, day, seconds, minute, hour, timezone);
                    } else {
                        matcher = gsDayMonthYear.matcher(stringToParse);
                        if (matcher.matches()) {
                            int year = Integer.parseInt(matcher.group(3));
                            int month = Integer.parseInt(matcher.group(2));
                            int day = Integer.parseInt(matcher.group(1));
                            int minute = 0;
                            int hour = 0;
                            int seconds = 0;
                            String timezone = ZoneId.systemDefault().getId();
                            result = DateUtil.generateDate(year, month, day, seconds, minute, hour, timezone);
                        } else {
                            matcher = htmlFormat.matcher(stringToParse);
                            if (matcher.matches()) {
                                int month;
                                String monthParsed;
                                switch (monthParsed = matcher.group(2)) {
                                    case "Jan": {
                                        month = 1;
                                        break;
                                    }
                                    case "Feb": {
                                        month = 2;
                                        break;
                                    }
                                    case "Mar": {
                                        month = 3;
                                        break;
                                    }
                                    case "Apr": {
                                        month = 4;
                                        break;
                                    }
                                    case "May": {
                                        month = 5;
                                        break;
                                    }
                                    case "Jun": {
                                        month = 6;
                                        break;
                                    }
                                    case "Jul": {
                                        month = 7;
                                        break;
                                    }
                                    case "Aug": {
                                        month = 8;
                                        break;
                                    }
                                    case "Sep": {
                                        month = 9;
                                        break;
                                    }
                                    case "Oct": {
                                        month = 10;
                                        break;
                                    }
                                    case "Nov": {
                                        month = 11;
                                        break;
                                    }
                                    default: {
                                        month = 12;
                                    }
                                }
                                int day = Integer.parseInt(matcher.group(3));
                                int year = Integer.parseInt(matcher.group(4));
                                int hour = Integer.parseInt(matcher.group(5));
                                int minute = Integer.parseInt(matcher.group(6));
                                int second = Integer.parseInt(matcher.group(7));
                                String timezone = matcher.group(8);
                                result = DateUtil.generateDate(year, month, day, second, minute, hour, timezone);
                            } else {
                                try {
                                    TemporalAccessor dt = CATCH_ALL_DATE_TIME_FORMATTER.parseBest(stringToParse, ZonedDateTime::from, LocalDateTime::from);
                                    if (dt instanceof ZonedDateTime) {
                                        result = (ZonedDateTime)dt;
                                    } else if (dt instanceof LocalDateTime) {
                                        LocalDateTime ldt = (LocalDateTime)dt;
                                        result = ldt.atZone(TimeZone.getDefault().toZoneId());
                                    } else {
                                        result = null;
                                    }
                                }
                                catch (DateTimeParseException e) {
                                    result = null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public static ZonedDateTime parseTime(String time) throws DateTimeParseException {
        TemporalAccessor ta = DateTimeFormatter.ISO_TIME.parseBest(StringUtils.removeStartIgnoreCase((String)time, (String)"T"), OffsetTime::from, LocalTime::from);
        ZonedDateTime result = ta instanceof OffsetTime ? ((OffsetTime)ta).atDate(LocalDate.now()).atZoneSameInstant(ZoneOffset.UTC) : (ta instanceof LocalTime ? ((LocalTime)ta).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC) : null);
        return result;
    }

    public static ZonedDateTime generateDate(int year, int month, int day, int second, int minute, int hour, String timezone) {
        TimeZone zone = TimeZone.getTimeZone(timezone);
        return ZonedDateTime.of(year, month, day, hour, minute, second, 0, zone.toZoneId());
    }

    static {
        gsYear = Pattern.compile("([0-9]{4})(-([0-2][0-9]):([0-5][0-9])([A-Z]))?");
        gsYearMonth = Pattern.compile("([0-9]{4})-([0-1][0-9])(-([0-2][0-9]):([0-5][0-9])([A-Z]{0,1}))?");
        gsYearMonthDayZ = Pattern.compile("([0-9]{4})-([0-1][0-9])-([0-2][0-9])Z");
        gsDayMonthYear = Pattern.compile("([0-2][0-9])/([0-1][0-9])/([0-9]{4})");
        htmlFormat = Pattern.compile("([a-zA-Z]{3}) ([a-zA-Z]{3}) ([0-9]{2}) ([0-9]{4}) ([0-2][0-9]):([0-5][0-9]):([0-5][0-9]) (.+)");
        ISO_OFFSET_DATE_TIME_NANOSECONDS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 3, 9, true).appendOffsetId().toFormatter();
        CATCH_ALL_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy[[-]M][[-]d['T'H[:m[:s[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]][XXX]]]]").parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).toFormatter();
    }
}

