/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import java.util.List;
import javax.inject.Inject;
import org.jclouds.compute.functions.GroupNamingConvention;

public final class FirewallTagNamingConvention {
    private final String sharedResourceName;

    public FirewallTagNamingConvention(String sharedResourceName) {
        this.sharedResourceName = sharedResourceName;
    }

    public String name(List<String> ports) {
        int prime = 31;
        int result = 1;
        for (String s : ports) {
            result = result * 31 + s.hashCode();
        }
        return String.format("%s-%s", this.sharedResourceName, Integer.toHexString(result));
    }

    public static final class Factory {
        private final GroupNamingConvention.Factory namingConvention;

        @Inject
        Factory(GroupNamingConvention.Factory namingConvention) {
            this.namingConvention = namingConvention;
        }

        public FirewallTagNamingConvention get(String groupName) {
            return new FirewallTagNamingConvention(this.namingConvention.create().sharedNameForGroup(groupName));
        }
    }
}

