/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSNonNegativeIntegerBinding
implements SimpleBinding {
    final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    final BigInteger MAX_INTEGER = BigInteger.valueOf(Integer.MAX_VALUE);

    @Override
    public QName getTarget() {
        return XS.NONNEGATIVEINTEGER;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return BigInteger.class;
    }

    @Override
    public Object parse(InstanceComponent instance, Object value) throws Exception {
        BigInteger number = (BigInteger)value;
        if (BigInteger.ZERO.compareTo(number) > 0) {
            throw new IllegalArgumentException("Value '" + number + "' must be non-negative (0 or above).");
        }
        if (this.MAX_INTEGER.compareTo(number) >= 0) {
            return number.intValue();
        }
        if (this.MAX_LONG.compareTo(number) >= 0) {
            return number.longValue();
        }
        return number;
    }

    @Override
    public String encode(Object object, String value) throws Exception {
        Number number = (Number)object;
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("Value '" + number + "' must be non-negative (0 or above).");
        }
        return value;
    }
}

