/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.util.z3950;

import java.util.Stack;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNodeVisitor;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.springframework.context.ApplicationContext;

class GNRemoteQueryDecoder {
    private Stack<Element> stack = new Stack();

    public GNRemoteQueryDecoder(QueryModel qm, ApplicationContext ctx) {
        try {
            InternalModelRootNode rn = qm.toInternalQueryModel(ctx);
            QueryNodeVisitor qnv = new QueryNodeVisitor(){

                public void visit(AttrPlusTermNode aptn) {
                    super.visit(aptn);
                    Element node = new Element("term");
                    if (aptn.getAccessPoint() != null) {
                        node.setAttribute(new Attribute("use", this.getAttrVal((AttrValue)aptn.getAccessPoint())));
                    }
                    if (aptn.getRelation() != null) {
                        node.setAttribute(new Attribute("relation", this.getAttrVal((AttrValue)aptn.getRelation())));
                    }
                    if (aptn.getStructure() != null) {
                        node.setAttribute(new Attribute("structure", this.getAttrVal((AttrValue)aptn.getStructure())));
                    }
                    if (aptn.getTruncation() != null) {
                        node.setAttribute(new Attribute("truncation", this.getAttrVal((AttrValue)aptn.getTruncation())));
                    }
                    node.addContent(aptn.getTermAsString(false));
                    GNRemoteQueryDecoder.this.stack.push(node);
                }

                public void visit(ComplexNode cn) {
                    super.visit(cn);
                    Element rightChild = (Element)GNRemoteQueryDecoder.this.stack.pop();
                    Element leftChild = (Element)GNRemoteQueryDecoder.this.stack.pop();
                    Element node = new Element(GNRemoteQueryDecoder.this.getOpString(cn.getOp()));
                    node.addContent((Content)leftChild);
                    node.addContent((Content)rightChild);
                    GNRemoteQueryDecoder.this.stack.push(node);
                }

                public void visit(InternalModelRootNode rn) {
                    super.visit(rn);
                    Element query = new Element("query");
                    query.addContent((Content)((Element)GNRemoteQueryDecoder.this.stack.pop()));
                    GNRemoteQueryDecoder.this.stack.push(query);
                }

                public void onAttrPlusTermNode(AttrPlusTermNode aptn) {
                    if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                        Log.debug((String)"geonetwork.sru", (Object)("doing nothing..." + aptn));
                    }
                }

                private String getAttrVal(AttrValue val) {
                    String value;
                    if (val == null || val.getValue() == null) {
                        return null;
                    }
                    String ret = value = val.getValue();
                    String[] temp = value.split("\\.");
                    if (temp != null && temp.length > 1) {
                        ret = temp[temp.length - 1];
                    }
                    return ret;
                }
            };
            qnv.visit(rn);
        }
        catch (InvalidQueryException iqe) {
            Log.error((String)"geonetwork.sru", (Object)("GNRemoteQueryDecoder - invalid query error: " + iqe.getMessage()), (Throwable)iqe);
        }
    }

    public Element getQuery() {
        return this.stack.peek();
    }

    public String toString() {
        return Xml.getString((Element)this.getQuery());
    }

    private String getOpString(int op) {
        switch (op) {
            case 1: {
                return "and";
            }
            case 3: {
                return "not";
            }
            case 2: {
                return "or";
            }
            case 4: {
                return "prox";
            }
        }
        return op + "";
    }
}

