/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroupId_;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.UserSpecs;
import org.fao.geonet.utils.Log;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;

public class LDAPSynchronizerJob
extends QuartzJobBean {
    private ConfigurableApplicationContext applicationContext;
    private DefaultSpringSecurityContextSource contextSource;

    protected void executeInternal(JobExecutionContext jobExecContext) throws JobExecutionException {
        try {
            if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                Log.debug((String)"geonetwork.ldap", (Object)"LDAPSynchronizerJob starting ...");
            }
            this.applicationContext = (ConfigurableApplicationContext)jobExecContext.getJobDetail().getJobDataMap().get((Object)"applicationContext");
            if (this.applicationContext == null) {
                Log.error((String)"geonetwork.ldap", (Object)"  Application context is null. Be sure to configure SchedulerFactoryBean job factory property with AutowiringSpringBeanJobFactory.");
            }
            ApplicationContextHolder.set((ConfigurableApplicationContext)this.applicationContext);
            this.runInTransaction(jobExecContext);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.ldap", (Object)"Unexpected error while synchronizing LDAP user in database", (Throwable)e);
        }
        if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
            Log.debug((String)"geonetwork.ldap", (Object)"LDAPSynchronizerJob done.");
        }
    }

    private void runInTransaction(JobExecutionContext jobExecContext) {
        JobDataMap jdm = jobExecContext.getJobDetail().getJobDataMap();
        this.contextSource = (DefaultSpringSecurityContextSource)jdm.get((Object)"contextSource");
        String ldapUserSearchFilter = (String)jdm.get((Object)"ldapUserSearchFilter");
        String ldapUserSearchBase = (String)jdm.get((Object)"ldapUserSearchBase");
        String ldapUserSearchAttribute = (String)jdm.get((Object)"ldapUserSearchAttribute");
        DirContext dc = this.contextSource.getReadOnlyContext();
        try {
            this.synchronizeUser((ApplicationContext)this.applicationContext, ldapUserSearchFilter, ldapUserSearchBase, ldapUserSearchAttribute, dc);
            String createNonExistingLdapGroup = (String)jdm.get((Object)"createNonExistingLdapGroup");
            if ("true".equals(createNonExistingLdapGroup)) {
                String ldapGroupSearchFilter = (String)jdm.get((Object)"ldapGroupSearchFilter");
                String ldapGroupSearchBase = (String)jdm.get((Object)"ldapGroupSearchBase");
                String ldapGroupSearchAttribute = (String)jdm.get((Object)"ldapGroupSearchAttribute");
                String ldapGroupSearchPattern = (String)jdm.get((Object)"ldapGroupSearchPattern");
                this.synchronizeGroup((ApplicationContext)this.applicationContext, ldapGroupSearchFilter, ldapGroupSearchBase, ldapGroupSearchAttribute, ldapGroupSearchPattern, dc);
            }
        }
        catch (SQLException | NamingException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                dc.close();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeUser(ApplicationContext applicationContext, String ldapUserSearchFilter, String ldapUserSearchBase, String ldapUserSearchAttribute, DirContext dc) throws NamingException, SQLException {
        HashSet<String> usernames = new HashSet<String>();
        try (NamingEnumeration<SearchResult> userList = null;){
            userList = dc.search(ldapUserSearchBase, ldapUserSearchFilter, null);
            while (userList.hasMore()) {
                SearchResult sr = userList.next();
                String username = sr.getAttributes().get(ldapUserSearchAttribute).get().toString();
                usernames.add(username);
            }
        }
        UserRepository userRepository = (UserRepository)applicationContext.getBean(UserRepository.class);
        UserGroupRepository userGroupRepository = (UserGroupRepository)applicationContext.getBean(UserGroupRepository.class);
        IMetadataUtils metadataRepository = (IMetadataUtils)applicationContext.getBean(IMetadataUtils.class);
        Specification spec = Specification.where((Specification)UserSpecs.hasAuthType((String)"LDAP")).and(Specification.not((Specification)UserSpecs.userIsNameNotOneOf(usernames)));
        List usersFound = userRepository.findAll(spec);
        Collection userIds = Collections2.transform((Collection)usersFound, (Function)new Function<User, Integer>(){

            @Nullable
            public Integer apply(@Nonnull User input) {
                return input.getId();
            }
        });
        if (!userIds.isEmpty()) {
            userGroupRepository.deleteAllByIdAttribute(UserGroupId_.userId, userIds);
        }
        for (User u : usersFound) {
            long nbOfUserRecord = metadataRepository.count((Specification<? extends AbstractMetadata>)MetadataSpecs.isOwnedByUser((int)u.getId()));
            if (nbOfUserRecord > 0L) {
                Log.error((String)"geonetwork.ldap", (Object)String.format("Cannot delete user '%s' who is owner of %d metadata record(s).", u.getUsername(), nbOfUserRecord));
                continue;
            }
            userRepository.deleteById((Object)u.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeGroup(ApplicationContext applicationContext, String ldapGroupSearchFilter, String ldapGroupSearchBase, String ldapGroupSearchAttribute, String ldapGroupSearchPattern, DirContext dc) throws NamingException, SQLException {
        try (NamingEnumeration<SearchResult> groupList = null;){
            groupList = dc.search(ldapGroupSearchBase, ldapGroupSearchFilter, null);
            Pattern ldapGroupSearchPatternCompiled = null;
            if (ldapGroupSearchPattern != null && !"".equals(ldapGroupSearchPattern)) {
                ldapGroupSearchPatternCompiled = Pattern.compile(ldapGroupSearchPattern);
            }
            while (groupList.hasMore()) {
                GroupRepository groupRepo;
                Group group;
                Matcher m;
                boolean b;
                SearchResult sr = groupList.next();
                String groupName = (String)sr.getAttributes().get(ldapGroupSearchAttribute).get();
                if (ldapGroupSearchPatternCompiled != null && !"".equals(ldapGroupSearchPattern) && (b = (m = ldapGroupSearchPatternCompiled.matcher(groupName)).matches())) {
                    groupName = m.group(1);
                }
                if ((group = (groupRepo = (GroupRepository)this.applicationContext.getBean(GroupRepository.class)).findByName(groupName)) != null) continue;
                group = new Group().setName(groupName);
                LanguageRepository langRepository = (LanguageRepository)this.applicationContext.getBean(LanguageRepository.class);
                List allLanguages = langRepository.findAll();
                for (Language l : allLanguages) {
                    group.getLabelTranslations().put(l.getId(), groupName);
                }
                groupRepo.save((Object)group);
            }
        }
    }

    public DefaultSpringSecurityContextSource getContextSource() {
        return this.contextSource;
    }

    public void setContextSource(DefaultSpringSecurityContextSource contextSource) {
        this.contextSource = contextSource;
    }
}

