/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceAlreadyExistException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.Group;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.FilePathChecker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/{portal}/api/logos"})
@Tag(name="logos", description="Logos operations")
@Controller(value="siteLogos")
public class LogosApi {
    private static final String[] iconExt = new String[]{".gif", ".png", ".jpg", ".jpeg"};
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    @Autowired
    SettingManager settingManager;
    @Autowired
    GroupRepository groupRepository;
    private final DirectoryStream.Filter<Path> iconFilter = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path file) {
            if (file == null || Files.exists(file, new LinkOption[0]) && !Files.isRegularFile(file, new LinkOption[0])) {
                return false;
            }
            if (file.getFileName() != null) {
                String name = file.getFileName().toString();
                for (String ext : iconExt) {
                    if (!name.endsWith(ext)) continue;
                    return true;
                }
            }
            return false;
        }
    };

    @Operation(summary="Get all logos", description="Logos are used for the catalog, the groups logos, and harvester icons. Logos are stored in the data directory in <dataDirectory>/resources/images/harvesting.<br/> Records are attached to a source. A source can be the local catalog or a harvester node. When a source is created, its logo is located in the images/logos folder with the source UUID as filename. For some sources the logo can be automatically retrieved (eg. when harvesting GeoNetwork catalogs). For others, the logo is usually manually defined when configuring the harvester.")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Set<String> getLogos(HttpServletRequest request) {
        ConfigurableApplicationContext context = ApplicationContextHolder.get();
        Set icons = ((Resources)context.getBean(Resources.class)).listFiles(ApiUtils.createServiceContext(request), "harvesting", this.iconFilter);
        HashSet<String> iconsList = new HashSet<String>(icons.size());
        for (Path i : icons) {
            iconsList.add(i.getFileName().toString());
        }
        return iconsList;
    }

    @Operation(summary="Add a logo", description="")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Logo added."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity addLogo(@Parameter(description="The logo image to upload") @RequestParam(value="file") MultipartFile[] file, @Parameter(description="Overwrite if exists", required=false) @RequestParam(defaultValue="false", required=false) boolean overwrite, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        Resources resources = (Resources)appContext.getBean(Resources.class);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        Path directoryPath = resources.locateHarvesterLogosDirSMVC((ApplicationContext)appContext);
        for (MultipartFile f : file) {
            String fileName = f.getOriginalFilename();
            this.checkFileName(fileName);
            try (Resources.ResourceHolder holder = resources.getWritableImage(serviceContext, fileName, directoryPath);){
                if (Files.exists(holder.getPath(), new LinkOption[0]) && !overwrite) {
                    holder.abort();
                    throw new ResourceAlreadyExistException(fileName);
                }
                Files.copy(f.getInputStream(), holder.getPath(), new CopyOption[0]);
            }
        }
        return new ResponseEntity(HttpStatus.CREATED);
    }

    private void checkFileName(String fileName) throws Exception {
        FilePathChecker.verify((String)fileName);
        if (StringUtils.isEmpty((String)fileName)) {
            throw new Exception("File name is not defined.");
        }
    }

    @Operation(summary="Get a logo", description="")
    @RequestMapping(path={"/{file:.+}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Logo returned."), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public void getLogo(@Parameter(description="The logo filename") @PathVariable String file, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block13: {
            this.checkFileName(file);
            FilePathChecker.verify((String)file);
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            Resources resources = (Resources)appContext.getBean(Resources.class);
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            Path logoDirectory = resources.locateHarvesterLogosDirSMVC((ApplicationContext)appContext);
            try (Resources.ResourceHolder image = resources.getImage(serviceContext, file, logoDirectory);){
                if (image != null) {
                    response.sendRedirect(String.format("%simages/harvesting/%s", this.settingManager.getBaseURL(), URLEncoder.encode(file, "UTF-8")));
                    break block13;
                }
                throw new ResourceNotFoundException(String.format("No logo found with filename '%s'.", file));
            }
        }
    }

    @Operation(summary="Remove a logo", description="")
    @RequestMapping(path={"/{file:.+}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Logo removed."), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public void deleteLogo(@Parameter(description="The logo filename to delete") @PathVariable String file, HttpServletRequest request) throws Exception {
        block14: {
            this.checkFileName(file);
            FilePathChecker.verify((String)file);
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            Resources resources = (Resources)appContext.getBean(Resources.class);
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            Path nodeLogoDirectory = resources.locateHarvesterLogosDirSMVC((ApplicationContext)appContext);
            try (Resources.ResourceHolder image = resources.getImage(serviceContext, file, nodeLogoDirectory);){
                if (image != null) {
                    List groups = this.groupRepository.findByLogo(file);
                    if (groups != null && groups.size() > 0) {
                        List groupIds = groups.stream().map(Group::getName).collect(Collectors.toList());
                        throw new IllegalArgumentException(String.format("Logo '%s' is used by %d group(s). Assign another logo to the following groups: %s.", file, groups.size(), groupIds.toString()));
                    }
                    resources.deleteImageIfExists(file, nodeLogoDirectory);
                    break block14;
                }
                throw new ResourceNotFoundException(String.format("No logo found with filename '%s'.", file));
            }
        }
    }
}

