/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.links;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.fao.geonet.domain.Link;
import org.springframework.data.domain.Page;

public class LinkAnalysisReport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(Page<Link> links, PrintWriter writer) throws Exception {
        CSVPrinter csvFilePrinter = null;
        try {
            CSVFormat csvFileFormat = CSVFormat.DEFAULT.withRecordSeparator("\n");
            csvFilePrinter = new CSVPrinter((Appendable)writer, csvFileFormat);
            String[] entries = new String[]{"URL", "LastState", "LastCheck", "Protocol", "Records"};
            csvFilePrinter.printRecord(Arrays.asList(entries));
            for (Link link : links) {
                ArrayList<String> record = new ArrayList<String>();
                record.add(link.getUrl());
                record.add(link.getLastState() + "");
                record.add(link.getLastCheck().getDateAndTime());
                record.add(link.getProtocol());
                record.add(link.getRecords().stream().map(r -> r.getMetadataUuid()).collect(Collectors.joining(" ")));
                csvFilePrinter.printRecord(record);
            }
        }
        finally {
            writer.flush();
            if (csvFilePrinter != null) {
                csvFilePrinter.flush();
            }
        }
    }
}

