/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.rmi;

import java.io.IOException;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.omm.SessionKilled;
import org.openrdf.sesame.repository.RepositoryList;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.SesameService;
import org.openrdf.sesame.server.SesameServer;

public class ServicesInterfaceImpl
implements SesameService {
    private static final String VERSION_SAIL = "org.openrdf.sesame.omm.VersionManagement";
    protected String thisSessionID;
    private SessionKilled sk = null;

    public static void getContext(Object cookie) {
        SessionContext sc = SessionContext.get(cookie);
        SessionContext.setContext(sc);
    }

    private SessionContext getContext() {
        SessionContext sc = null;
        sc = SessionContext.getContext();
        if (sc == null) {
            sc = SessionContext.get(this.thisSessionID);
        }
        if (sc == null) {
            sc = new SessionContext();
            SessionContext.put(this.thisSessionID, sc);
            this.sk = new SessionKilled(this.thisSessionID);
            System.out.println("new context created (" + this.thisSessionID + ")");
        }
        SessionContext.setContext(sc);
        return sc;
    }

    public ServicesInterfaceImpl(String theID) {
        System.out.println("ServicesInterfaceImpl constructed");
        this.thisSessionID = theID;
        this.getContext();
    }

    public RepositoryList getRepositoryList() throws IOException {
        return SesameServer.getLocalService().getRepositoryList();
    }

    public SesameRepository getRepository(String repositoryID) throws UnknownRepositoryException, ConfigurationException, IOException {
        return SesameServer.getLocalService().getRepository(repositoryID);
    }

    public void login(String username, String password) throws AccessDeniedException, IOException {
        SesameServer.getLocalService().login(username, password);
    }

    public void logout() throws IOException {
        SesameServer.getLocalService().logout();
    }
}

