/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.Role;
import org.openrdf.sesame.sailimpl.omm.security.Rule;

public class RoleImpl
implements Role {
    private int id;
    private String name = null;
    private String description = null;
    private Set rules = new HashSet();
    private Set parentRoles = new HashSet();
    private String uri = null;
    static int lastId = 0;

    public RoleImpl(int id, String name, String description) throws NullParameterException {
        if (null == name || null == description) {
            throw new NullParameterException("Role [name] and [description] should not be [null].");
        }
        this.id = id;
        if (id > lastId) {
            lastId = id;
        }
        this.name = name;
        this.description = description;
    }

    public RoleImpl() {
        this.id = ++lastId;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description;
    }

    public void addRule(Rule rule) throws NullParameterException {
        if (null == rule) {
            throw new NullParameterException("Added [rule] should not be [null].");
        }
        this.rules.add(rule);
    }

    public void removeRule(Rule rule) throws NullParameterException {
        if (null == rule) {
            throw new NullParameterException("Removed [rule] should not be [null].");
        }
        this.rules.remove(rule);
    }

    public Set getRules(boolean direct) {
        HashSet result;
        if (direct) {
            result = this.rules;
        } else {
            result = new HashSet();
            result.addAll(this.rules);
            ArrayList parents = new ArrayList(this.parentRoles);
            for (int i = 0; i < parents.size(); ++i) {
                Role pr = (Role)parents.get(i);
                result.addAll(pr.getRules(direct));
            }
        }
        return result;
    }

    public Set getParentRoles() {
        return this.parentRoles;
    }

    public void setParentRoles(Set parents) throws NullParameterException {
        if (null == parents) {
            throw new NullParameterException("Set of parent roles [parents] should not be [null].");
        }
        this.parentRoles = parents;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String roleName) throws NullParameterException {
        if (null == roleName) {
            throw new NullParameterException("Role [name] should not be [null].");
        }
    }

    public ArrayList toSql() {
        ArrayList<String> list = new ArrayList<String>(3);
        StringBuffer query = new StringBuffer();
        query.append("INSERT INTO ");
        query.append("roles");
        query.append(" VALUES ");
        query.append("(").append(this.id);
        query.append(",'");
        query.append(this.name);
        query.append("','");
        query.append(this.description).append("');");
        list.add(query.toString());
        ArrayList rulz = new ArrayList(this.rules);
        for (int ri = 0; ri < rulz.size(); ++ri) {
            query = new StringBuffer();
            Rule rule = (Rule)rulz.get(ri);
            query.append("INSERT INTO ");
            query.append("roles_rules");
            query.append(" VALUES ");
            query.append("(").append(this.id);
            query.append(",");
            query.append(rule.getId());
            query.append(");");
            list.add(query.toString());
        }
        ArrayList parentz = new ArrayList(this.parentRoles);
        for (int pi = 0; pi < parentz.size(); ++pi) {
            query = new StringBuffer();
            Role role = (Role)parentz.get(pi);
            query.append("INSERT INTO ");
            query.append("roles_hierarchy");
            query.append(" VALUES ");
            query.append("(").append(this.id);
            query.append(",");
            query.append(role.getId());
            query.append(");");
            list.add(query.toString());
        }
        return list;
    }

    public static Set getRules(Set roles, boolean direct) {
        ArrayList list = new ArrayList(roles);
        HashSet result = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            Role role = (Role)list.get(i);
            result.addAll(role.getRules(direct));
        }
        return result;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }
}

