/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ReverseCodeTableHandler
extends DefaultHandler {
    private Hashtable charset;
    private Vector combiningchars;
    private boolean useAlt = false;
    private Integer isocode;
    private char[] marc;
    private Character ucs;
    private boolean combining;
    private String tag;
    private StringBuffer data;
    private Locator locator;

    public Hashtable getCharSets() {
        return this.charset;
    }

    public Vector getCombiningChars() {
        return this.combiningchars;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXParseException {
        if (name.equals("characterSet")) {
            this.isocode = Integer.valueOf(atts.getValue("ISOcode"), 16);
        } else if (name.equals("marc")) {
            this.data = new StringBuffer();
        } else if (name.equals("codeTables")) {
            this.charset = new Hashtable();
            this.combiningchars = new Vector();
        } else if (name.equals("ucs")) {
            this.data = new StringBuffer();
        } else if (name.equals("alt")) {
            this.data = new StringBuffer();
        } else if (name.equals("code")) {
            this.combining = false;
        } else if (name.equals("isCombining")) {
            this.data = new StringBuffer();
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.data != null) {
            this.data.append(ch, start, length);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXParseException {
        if (name.equals("marc")) {
            String marcstr = this.data.toString();
            if (marcstr.length() == 6) {
                this.marc = new char[3];
                this.marc[0] = (char)Integer.parseInt(marcstr.substring(0, 2), 16);
                this.marc[1] = (char)Integer.parseInt(marcstr.substring(2, 4), 16);
                this.marc[2] = (char)Integer.parseInt(marcstr.substring(4, 6), 16);
            } else {
                this.marc = new char[1];
                this.marc[0] = (char)Integer.parseInt(marcstr, 16);
            }
        } else if (name.equals("ucs")) {
            if (this.data.length() > 0) {
                this.ucs = new Character((char)Integer.parseInt(this.data.toString(), 16));
            } else {
                this.useAlt = true;
            }
        } else if (name.equals("alt")) {
            if (this.useAlt && this.data.length() > 0) {
                this.ucs = new Character((char)Integer.parseInt(this.data.toString(), 16));
                this.useAlt = false;
            }
        } else if (name.equals("code")) {
            if (this.combining) {
                this.combiningchars.add(this.ucs);
            }
            if (this.charset.get(this.ucs) == null) {
                Hashtable<Integer, char[]> h = new Hashtable<Integer, char[]>(1);
                h.put(this.isocode, this.marc);
                this.charset.put(this.ucs, h);
            } else {
                Hashtable h = (Hashtable)this.charset.get(this.ucs);
                h.put(this.isocode, this.marc);
            }
        } else if (name.equals("isCombining") && this.data.toString().equals("true")) {
            this.combining = true;
        }
        this.data = null;
    }

    public static void main(String[] args) {
        Object charsets = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            File file = new File("C:\\Documents and Settings\\ckeith\\Desktop\\Projects\\Code Tables\\codetables.xml");
            InputSource src = new InputSource(new FileInputStream(file));
            ReverseCodeTableHandler saxUms = new ReverseCodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
            System.err.println("Exception: " + exc);
        }
    }
}

