/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.inject.Inject;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;

public class ParseRecord
implements Function<HttpResponse, RecordDetail> {
    private final ParseJson<RawRecord> json;
    static final Function<RawRecord, RecordDetail> toRecordDetails = new Function<RawRecord, RecordDetail>(){

        public RecordDetail apply(RawRecord rawRecord) {
            Record record = Record.builder().name(rawRecord.name).type(rawRecord.type).ttl(rawRecord.ttl).data(rawRecord.data).priority(rawRecord.priority).comment(rawRecord.comment).build();
            RecordDetail recordDetails = RecordDetail.builder().id(rawRecord.id).created(rawRecord.created).updated(rawRecord.updated).record(record).build();
            return recordDetails;
        }
    };

    @Inject
    ParseRecord(ParseJson<RawRecord> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public RecordDetail apply(HttpResponse response) {
        RawRecord rawRecord = (RawRecord)this.json.apply(response);
        if (rawRecord == null) {
            return null;
        }
        return (RecordDetail)toRecordDetails.apply((Object)rawRecord);
    }

    static class RawRecord {
        public String id;
        public String name;
        public String type;
        public int ttl;
        public String data;
        public Integer priority;
        public String comment;
        public Date created;
        public Date updated;

        @ConstructorProperties(value={"id", "name", "type", "ttl", "data", "priority", "comment", "created", "updated"})
        protected RawRecord(String id, String name, String type, int ttl, String data, Integer priority, String comment, Date created, Date updated) {
            this.id = id;
            this.name = name;
            this.type = type;
            this.ttl = ttl;
            this.data = data;
            this.priority = priority;
            this.comment = comment;
            this.created = created;
            this.updated = updated;
        }
    }
}

