/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.fao.geonet.util.FileUtil;
import org.fao.geonet.utils.Log;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Deprecated
@Controller(value="/log")
public class LogConfig {
    private static final String fileAppenderName = "fileAppender";
    private static final int maxLines = 20000;
    private FileAppender fileAppender = null;

    @PostConstruct
    public void init() throws Exception {
        this.isAppenderLogFileLoaded();
    }

    boolean isAppenderLogFileLoaded() {
        if (this.fileAppender == null || this.fileAppender.getFile() == null) {
            this.fileAppender = (FileAppender)Logger.getLogger((String)"geonetwork").getAppender(fileAppenderName);
            if (this.fileAppender == null) {
                this.fileAppender = (FileAppender)Logger.getLogger((String)"jeeves").getAppender(fileAppenderName);
            }
            if (this.fileAppender == null) {
                Log.error((String)"geonetwork", (Object)"Error when getting appender named 'fileAppender'. Check your log configuration file. No appender found.");
                return false;
            }
            String logFileName = this.fileAppender.getFile();
            if (logFileName == null) {
                Log.error((String)"geonetwork", (Object)"Error when getting logger file for the appender named 'fileAppender'. Check your log configuration file. A FileAppender is required to return last activity to the user interface.Appender file not found.");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{portal}/{lang}/log/file"}, produces={"application/octet-stream"})
    @ResponseBody
    public void getLog(HttpServletResponse response) throws IOException {
        ZipOutputStream zos;
        block6: {
            block5: {
                if (!this.isAppenderLogFileLoaded()) break block5;
                File file = new File(this.fileAppender.getFile());
                String fname = String.valueOf(Calendar.getInstance().getTimeInMillis());
                response.setContentType("application/zip");
                response.setContentLength((int)file.length());
                String headerKey = "Content-Disposition";
                String headerValue = String.format("attachment; filename=\"%s\"", "export-log-" + fname + ".zip");
                response.setHeader(headerKey, headerValue);
                int read = 0;
                byte[] bytes = new byte[1024];
                zos = null;
                FileInputStream in = null;
                try {
                    zos = new ZipOutputStream((OutputStream)response.getOutputStream());
                    ZipEntry ze = new ZipEntry(file.getName());
                    zos.putNextEntry(ze);
                    in = new FileInputStream(file);
                    while ((read = ((InputStream)in).read(bytes)) != -1) {
                        zos.write(bytes, 0, read);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    if (zos != null) {
                        zos.flush();
                    }
                    IOUtils.closeQuietly((OutputStream)zos);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                if (zos != null) {
                    zos.flush();
                }
                break block6;
            }
            throw new RuntimeException("No log file found for download. Check logger configuration.");
        }
        IOUtils.closeQuietly((OutputStream)zos);
    }

    @RequestMapping(value={"/{portal}/{lang}/log/activity"}, produces={"text/plain"})
    @ResponseBody
    public String activity(@RequestParam(value="lines", required=false, defaultValue="2000") int lines) {
        String lastActivity = null;
        if (!this.isAppenderLogFileLoaded()) {
            throw new RuntimeException("No log file found. Check logger configuration.");
        }
        lastActivity = FileUtil.readLastLines((File)new File(this.fileAppender.getFile()), (int)Math.min(lines, 20000));
        return lastActivity;
    }
}

