/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.harvesting.notifier;

import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

public class GetNotificationSettings
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        Element res = new Element("notification");
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager settings = (SettingManager)gc.getBean(SettingManager.class);
        this.setProperty(res, settings, "template", "mail/template");
        this.setProperty(res, settings, "templateError", "mail/templateError");
        this.setProperty(res, settings, "templateWarning", "mail/templateWarning");
        this.setProperty(res, settings, "subject", "mail/subject");
        this.setProperty(res, settings, "enabled", "mail/enabled");
        this.setProperty(res, settings, "level1", "mail/level1");
        this.setProperty(res, settings, "level2", "mail/level2");
        this.setProperty(res, settings, "level3", "mail/level3");
        this.setProperty(res, settings, "recipient", "mail/recipient", ",");
        return res;
    }

    private void setProperty(Element res, SettingManager settings, String property, String path) {
        this.setProperty(res, settings, property, path, null);
    }

    private void setProperty(Element res, SettingManager settings, String property, String path, String split) {
        try {
            String value = settings.getValue("system/harvesting/" + path);
            if (split != null && value != null) {
                String[] values;
                for (String v : values = value.split(split)) {
                    Element tmp = new Element(property);
                    tmp.setText(v);
                    res.addContent((Content)tmp);
                }
            } else {
                Element tmp = new Element(property);
                tmp.setText(value);
                res.addContent((Content)tmp);
            }
        }
        catch (Throwable t) {
            Log.error((String)"geonetwork.harvester", (Object)t.getMessage(), (Throwable)t);
        }
    }
}

