/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.util.Display;
import bak.pcj.util.Exceptions;
import java.io.Serializable;

public class CharRange
implements Comparable,
Serializable {
    private char first;
    private char last;

    public CharRange(char first, char last) {
        if (last < first) {
            Exceptions.invalidRangeBounds(String.valueOf(first), String.valueOf(last));
        }
        this.first = first;
        this.last = last;
    }

    public char first() {
        return this.first;
    }

    public char last() {
        return this.last;
    }

    public int length() {
        return this.last - this.first + 1;
    }

    public boolean intersects(CharRange range) {
        return this.first >= range.first && this.first <= range.last || range.first >= this.first && range.first <= this.last;
    }

    public boolean adjacentTo(CharRange range) {
        return this.last + '\u0001' == range.first || range.last + '\u0001' == this.first;
    }

    public boolean canMergeWith(CharRange range) {
        return this.intersects(range) || this.adjacentTo(range);
    }

    public CharRange mergeWith(CharRange range) {
        if (!this.canMergeWith(range)) {
            Exceptions.cannotMergeRanges(this, range);
        }
        return this.quickMergeWith(range);
    }

    private CharRange quickMergeWith(CharRange range) {
        char nfirst = this.first < range.first ? this.first : range.first;
        char nlast = this.last > range.last ? this.last : range.last;
        return new CharRange(nfirst, nlast);
    }

    public CharRange tryMergeWith(CharRange range) {
        if (!this.canMergeWith(range)) {
            return null;
        }
        return this.quickMergeWith(range);
    }

    public int intersectionLength(CharRange range) {
        int len;
        if (this.first >= range.first && this.first <= range.last) {
            char end = this.last <= range.last ? this.last : range.last;
            len = end - this.first + 1;
        } else if (range.first >= this.first && range.first <= this.last) {
            char end = this.last <= range.last ? this.last : range.last;
            len = end - range.first + 1;
        } else {
            len = 0;
        }
        return len;
    }

    public boolean contains(char v) {
        return v >= this.first && v <= this.last;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CharRange)) {
            return false;
        }
        CharRange range = (CharRange)obj;
        return this.first == range.first && this.last == range.last;
    }

    public int compareTo(Object obj) {
        CharRange range = (CharRange)obj;
        if (this.first < range.first) {
            return -1;
        }
        if (this.first > range.first) {
            return 1;
        }
        if (this.last < range.last) {
            return -1;
        }
        if (this.last > range.last) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.first ^ this.last;
    }

    public String toString() {
        return Display.display(this.first) + "-" + Display.display(this.last);
    }
}

