/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.geotools.renderer.lite.LiteFeatureTypeStyle;
import org.geotools.renderer.lite.MarkFeatureIterator;
import org.geotools.renderer.lite.SortKey;
import org.geotools.renderer.lite.StreamingRenderer;
import org.opengis.feature.Feature;
import org.opengis.filter.sort.SortBy;

class ZGroupLayerPainter
implements AutoCloseable {
    Feature currentFeature;
    MarkFeatureIterator iterator;
    List<LiteFeatureTypeStyle> lfts;
    SortKey currentKey;
    SortBy[] sortBy;
    StreamingRenderer renderer;
    StreamingRenderer.RenderableFeature renderable;
    boolean complete = false;

    public ZGroupLayerPainter(MarkFeatureIterator iterator, List<LiteFeatureTypeStyle> lfts, StreamingRenderer renderer, String layerId) throws IOException {
        this.iterator = iterator;
        this.lfts = lfts;
        this.renderer = renderer;
        this.sortBy = lfts.get((int)0).sortBy;
        this.currentKey = new SortKey(this.sortBy.length);
        this.renderer = renderer;
        this.renderable = renderer.createRenderableFeature(layerId, true);
        this.next();
    }

    public void paintKey(SortKey reference) throws IOException {
        if (!reference.equals(this.currentKey)) {
            return;
        }
        Feature startFeature = this.currentFeature;
        this.iterator.mark();
        for (int i = 0; i < this.lfts.size(); ++i) {
            while (!this.complete && reference.equals(this.currentKey)) {
                this.renderable.setFeature(this.currentFeature);
                LiteFeatureTypeStyle lftsi = this.lfts.get(i);
                this.renderer.processFeature(this.renderable, lftsi, lftsi.projectionHandler);
                if (this.renderer.renderingStopRequested) {
                    return;
                }
                this.next();
            }
            if (i >= this.lfts.size() - 1) continue;
            this.iterator.reset();
            this.complete = false;
            this.currentFeature = startFeature;
            this.currentKey.copy(reference);
        }
    }

    private void next() {
        if (this.iterator.hasNext()) {
            this.currentFeature = this.iterator.next();
            for (int i = 0; i < this.sortBy.length; ++i) {
                Object value;
                SortBy sb = this.sortBy[i];
                this.currentKey.components[i] = sb == SortBy.NATURAL_ORDER || sb == SortBy.REVERSE_ORDER ? this.currentFeature.getIdentifier().getID() : (value = sb.getPropertyName().evaluate((Object)this.currentFeature));
            }
        } else {
            this.complete = true;
        }
    }

    SortKey getCurrentKey() {
        return this.complete ? null : this.currentKey;
    }

    public boolean complete() {
        return this.complete;
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
            this.currentFeature = null;
            this.currentKey = null;
        }
    }

    public String toString() {
        return "ZGroupLayerPainter [currentFeature=" + this.currentFeature + ", iterator=" + this.iterator + ", lfts=" + this.lfts + ", currentKey=" + this.currentKey + ", sortBy=" + Arrays.toString(this.sortBy) + ", complete=" + this.complete + "]";
    }
}

