/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup.job.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class TermsGroupConfig
implements Validatable,
ToXContentObject {
    static final String NAME = "terms";
    private static final String FIELDS = "fields";
    private static final ConstructingObjectParser<TermsGroupConfig, Void> PARSER = new ConstructingObjectParser("terms", true, args -> {
        List fields = (List)args[0];
        return new TermsGroupConfig(fields != null ? fields.toArray(new String[fields.size()]) : null);
    });
    private final String[] fields;

    public TermsGroupConfig(String ... fields) {
        this.fields = fields;
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.fields == null || this.fields.length == 0) {
            validationException.addValidationError("Fields must have at least one value");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public String[] getFields() {
        return this.fields;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELDS, (Object)this.fields);
        return builder.endObject();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TermsGroupConfig that = (TermsGroupConfig)other;
        return Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fields);
    }

    public static TermsGroupConfig fromXContent(XContentParser parser) throws IOException {
        return (TermsGroupConfig)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField(FIELDS, new String[0]));
    }
}

