/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.List;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public abstract class ClusterStateUpdateTask
implements ClusterStateTaskConfig,
ClusterStateTaskExecutor<ClusterStateUpdateTask>,
ClusterStateTaskListener {
    private final Priority priority;
    @Nullable
    private final TimeValue timeout;

    public ClusterStateUpdateTask() {
        this(Priority.NORMAL);
    }

    public ClusterStateUpdateTask(Priority priority) {
        this(priority, null);
    }

    public ClusterStateUpdateTask(TimeValue timeout) {
        this(Priority.NORMAL, timeout);
    }

    public ClusterStateUpdateTask(Priority priority, TimeValue timeout) {
        this.priority = priority;
        this.timeout = timeout;
    }

    @Override
    public final ClusterStateTaskExecutor.ClusterTasksResult<ClusterStateUpdateTask> execute(ClusterState currentState, List<ClusterStateUpdateTask> tasks) throws Exception {
        ClusterState result = this.execute(currentState);
        return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(result);
    }

    @Override
    public String describeTasks(List<ClusterStateUpdateTask> tasks) {
        return "";
    }

    public abstract ClusterState execute(ClusterState var1) throws Exception;

    @Override
    public abstract void onFailure(String var1, Exception var2);

    @Override
    public final void clusterStatePublished(ClusterChangedEvent clusterChangedEvent) {
    }

    @Override
    @Nullable
    public final TimeValue timeout() {
        return this.timeout;
    }

    @Override
    public final Priority priority() {
        return this.priority;
    }

    @Override
    public final boolean runOnlyOnMaster() {
        return true;
    }
}

