/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.get.MultiGetAction;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.core.Nullable;

public class MultiGetRequestBuilder
extends ActionRequestBuilder<MultiGetRequest, MultiGetResponse> {
    public MultiGetRequestBuilder(ElasticsearchClient client, MultiGetAction action) {
        super(client, action, new MultiGetRequest());
    }

    public MultiGetRequestBuilder add(String index, @Nullable String type, String id) {
        ((MultiGetRequest)this.request).add(index, type, id);
        return this;
    }

    public MultiGetRequestBuilder add(String index, @Nullable String type, Iterable<String> ids) {
        for (String id : ids) {
            ((MultiGetRequest)this.request).add(index, type, id);
        }
        return this;
    }

    public MultiGetRequestBuilder add(String index, @Nullable String type, String ... ids) {
        for (String id : ids) {
            ((MultiGetRequest)this.request).add(index, type, id);
        }
        return this;
    }

    public MultiGetRequestBuilder add(MultiGetRequest.Item item) {
        ((MultiGetRequest)this.request).add(item);
        return this;
    }

    public MultiGetRequestBuilder setPreference(String preference) {
        ((MultiGetRequest)this.request).preference(preference);
        return this;
    }

    public MultiGetRequestBuilder setRefresh(boolean refresh) {
        ((MultiGetRequest)this.request).refresh(refresh);
        return this;
    }

    public MultiGetRequestBuilder setRealtime(boolean realtime) {
        ((MultiGetRequest)this.request).realtime(realtime);
        return this;
    }
}

