/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.InPlaceMergeSorter;

public abstract class BlendedTermQuery
extends Query {
    private final Term[] terms;
    private final float[] boosts;
    private volatile TermAndBoost[] equalTermsAndBoosts = null;

    public BlendedTermQuery(Term[] terms, float[] boosts) {
        if (terms == null || terms.length == 0) {
            throw new IllegalArgumentException("terms must not be null or empty");
        }
        if (boosts != null && boosts.length != terms.length) {
            throw new IllegalArgumentException("boosts must have the same size as terms");
        }
        this.terms = terms;
        this.boosts = boosts;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = super.rewrite(reader);
        if (rewritten != this) {
            return rewritten;
        }
        IndexReaderContext context = reader.getContext();
        TermStates[] ctx = new TermStates[this.terms.length];
        int[] docFreqs = new int[ctx.length];
        for (int i = 0; i < this.terms.length; ++i) {
            ctx[i] = TermStates.build((IndexReaderContext)context, (Term)this.terms[i], (boolean)true);
            docFreqs[i] = ctx[i].docFreq();
        }
        int maxDoc = reader.maxDoc();
        this.blend(ctx, maxDoc, reader);
        return this.topLevelQuery(this.terms, ctx, docFreqs, maxDoc);
    }

    protected abstract Query topLevelQuery(Term[] var1, TermStates[] var2, int[] var3, int var4);

    protected void blend(final TermStates[] contexts, int maxDoc, IndexReader reader) throws IOException {
        int i;
        TermStates ctx;
        if (contexts.length <= 1) {
            return;
        }
        int max = 0;
        long minSumTTF = Long.MAX_VALUE;
        for (int i2 = 0; i2 < contexts.length; ++i2) {
            TermStates ctx2 = contexts[i2];
            int df = ctx2.docFreq();
            max = Math.max(df, max);
            if (ctx2.totalTermFreq() <= 0L) continue;
            minSumTTF = Math.min(minSumTTF, reader.getSumTotalTermFreq(this.terms[i2].field()));
        }
        if ((long)maxDoc > minSumTTF) {
            maxDoc = (int)minSumTTF;
        }
        if (max == 0) {
            return;
        }
        long sumTTF = 0L;
        final int[] tieBreak = new int[contexts.length];
        for (int i3 = 0; i3 < tieBreak.length; ++i3) {
            tieBreak[i3] = i3;
        }
        new InPlaceMergeSorter(){

            protected void swap(int i, int j) {
                int tmp = tieBreak[i];
                tieBreak[i] = tieBreak[j];
                tieBreak[j] = tmp;
            }

            protected int compare(int i, int j) {
                return Integer.compare(contexts[tieBreak[j]].docFreq(), contexts[tieBreak[i]].docFreq());
            }
        }.sort(0, tieBreak.length);
        int prev = contexts[tieBreak[0]].docFreq();
        int actualDf = Math.min(maxDoc, max);
        assert (actualDf >= 0) : "DF must be >= 0";
        int[] nArray = tieBreak;
        int n = nArray.length;
        for (int j = 0; j < n && (ctx = contexts[i = nArray[j]]).docFreq() != 0; ++j) {
            int current = ctx.docFreq();
            if (prev > current) {
                ++actualDf;
            }
            contexts[i] = ctx = BlendedTermQuery.adjustDF(reader.getContext(), ctx, Math.min(maxDoc, actualDf));
            prev = current;
            sumTTF += ctx.totalTermFreq();
        }
        sumTTF = Math.min(sumTTF, minSumTTF);
        for (int i4 = 0; i4 < contexts.length; ++i4) {
            int df = contexts[i4].docFreq();
            if (df == 0) continue;
            contexts[i4] = this.adjustTTF(reader.getContext(), contexts[i4], sumTTF);
        }
    }

    private TermStates adjustTTF(IndexReaderContext readerContext, TermStates termContext, long sumTTF) throws IOException {
        assert (termContext.wasBuiltFor(readerContext));
        TermStates newTermContext = new TermStates(readerContext);
        List leaves = readerContext.leaves();
        int len = leaves == null ? 1 : leaves.size();
        int df = termContext.docFreq();
        long ttf = sumTTF;
        for (int i = 0; i < len; ++i) {
            TermState termState = termContext.get((LeafReaderContext)leaves.get(i));
            if (termState == null) continue;
            newTermContext.register(termState, i, df, ttf);
            df = 0;
            ttf = 0L;
        }
        return newTermContext;
    }

    private static TermStates adjustDF(IndexReaderContext readerContext, TermStates ctx, int newDocFreq) throws IOException {
        assert (ctx.wasBuiltFor(readerContext));
        long newTTF = Math.max(ctx.totalTermFreq(), (long)newDocFreq);
        List leaves = readerContext.leaves();
        int len = leaves == null ? 1 : leaves.size();
        TermStates newCtx = new TermStates(readerContext);
        for (int i = 0; i < len; ++i) {
            TermState termState = ctx.get((LeafReaderContext)leaves.get(i));
            if (termState == null) continue;
            newCtx.register(termState, i, newDocFreq, newTTF);
            newDocFreq = 0;
            newTTF = 0L;
        }
        return newCtx;
    }

    public List<Term> getTerms() {
        return Arrays.asList(this.terms);
    }

    public String toString(String field) {
        StringBuilder builder = new StringBuilder("blended(terms:[");
        for (int i = 0; i < this.terms.length; ++i) {
            builder.append(this.terms[i]);
            float boost = 1.0f;
            if (this.boosts != null) {
                boost = this.boosts[i];
            }
            if (boost != 1.0f) {
                builder.append('^').append(boost);
            }
            builder.append(", ");
        }
        if (this.terms.length > 0) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("])");
        return builder.toString();
    }

    public void visit(QueryVisitor visitor) {
        Set fields = Arrays.stream(this.terms).map(Term::field).collect(Collectors.toSet());
        for (String field : fields) {
            if (visitor.acceptField(field)) continue;
            return;
        }
        visitor.getSubVisitor(BooleanClause.Occur.SHOULD, (Query)this).consumeTerms((Query)this, this.terms);
    }

    private TermAndBoost[] equalsTermsAndBoosts() {
        if (this.equalTermsAndBoosts != null) {
            return this.equalTermsAndBoosts;
        }
        if (this.terms.length == 1) {
            float boost = this.boosts != null ? this.boosts[0] : 1.0f;
            this.equalTermsAndBoosts = new TermAndBoost[]{new TermAndBoost(this.terms[0], boost)};
        } else {
            this.equalTermsAndBoosts = new TermAndBoost[this.terms.length];
            for (int i = 0; i < this.terms.length; ++i) {
                float boost = this.boosts != null ? this.boosts[i] : 1.0f;
                this.equalTermsAndBoosts[i] = new TermAndBoost(this.terms[i], boost);
            }
            ArrayUtil.timSort((Comparable[])this.equalTermsAndBoosts);
        }
        return this.equalTermsAndBoosts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        BlendedTermQuery that = (BlendedTermQuery)((Object)o);
        return Arrays.equals(this.equalsTermsAndBoosts(), that.equalsTermsAndBoosts());
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), Arrays.hashCode(this.equalsTermsAndBoosts()));
    }

    @Deprecated
    public static BlendedTermQuery commonTermsBlendedQuery(Term[] terms, final float[] boosts, final float maxTermFrequency) {
        return new BlendedTermQuery(terms, boosts){

            @Override
            protected Query topLevelQuery(Term[] terms, TermStates[] ctx, int[] docFreqs, int maxDoc) {
                BooleanQuery.Builder highBuilder = new BooleanQuery.Builder();
                BooleanQuery.Builder lowBuilder = new BooleanQuery.Builder();
                for (int i = 0; i < terms.length; ++i) {
                    TermQuery query = new TermQuery(terms[i], ctx[i]);
                    if (boosts != null && boosts[i] != 1.0f) {
                        query = new BoostQuery((Query)query, boosts[i]);
                    }
                    if (maxTermFrequency >= 1.0f && (float)docFreqs[i] > maxTermFrequency || docFreqs[i] > (int)Math.ceil(maxTermFrequency * (float)maxDoc)) {
                        highBuilder.add((Query)query, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    lowBuilder.add((Query)query, BooleanClause.Occur.SHOULD);
                }
                BooleanQuery high = highBuilder.build();
                BooleanQuery low = lowBuilder.build();
                if (low.clauses().isEmpty()) {
                    BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
                    for (BooleanClause booleanClause : high) {
                        queryBuilder.add(booleanClause.getQuery(), BooleanClause.Occur.MUST);
                    }
                    return queryBuilder.build();
                }
                if (high.clauses().isEmpty()) {
                    return low;
                }
                return new BooleanQuery.Builder().add((Query)high, BooleanClause.Occur.SHOULD).add((Query)low, BooleanClause.Occur.MUST).build();
            }
        };
    }

    public static BlendedTermQuery dismaxBlendedQuery(Term[] terms, float tieBreakerMultiplier) {
        return BlendedTermQuery.dismaxBlendedQuery(terms, null, tieBreakerMultiplier);
    }

    public static BlendedTermQuery dismaxBlendedQuery(Term[] terms, final float[] boosts, final float tieBreakerMultiplier) {
        return new BlendedTermQuery(terms, boosts){

            @Override
            protected Query topLevelQuery(Term[] terms, TermStates[] ctx, int[] docFreqs, int maxDoc) {
                ArrayList<TermQuery> queries = new ArrayList<TermQuery>(ctx.length);
                for (int i = 0; i < terms.length; ++i) {
                    TermQuery query = new TermQuery(terms[i], ctx[i]);
                    if (boosts != null && boosts[i] != 1.0f) {
                        query = new BoostQuery((Query)query, boosts[i]);
                    }
                    queries.add(query);
                }
                return new DisjunctionMaxQuery(queries, tieBreakerMultiplier);
            }
        };
    }

    private class TermAndBoost
    implements Comparable<TermAndBoost> {
        protected final Term term;
        protected float boost;

        protected TermAndBoost(Term term, float boost) {
            this.term = term;
            this.boost = boost;
        }

        @Override
        public int compareTo(TermAndBoost other) {
            int compareTo = this.term.compareTo(other.term);
            if (compareTo == 0) {
                compareTo = Float.compare(this.boost, other.boost);
            }
            return compareTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TermAndBoost)) {
                return false;
            }
            TermAndBoost that = (TermAndBoost)o;
            return this.term.equals((Object)that.term) && Float.compare(this.boost, that.boost) == 0;
        }

        public int hashCode() {
            return 31 * this.term.hashCode() + Float.hashCode(this.boost);
        }
    }
}

