/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.listener.metadata.draft;

import java.util.Arrays;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.events.md.MetadataStatusChanged;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class RetireRecord
implements ApplicationListener<MetadataStatusChanged> {
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    ServiceManager serviceManager;
    @Autowired
    IMetadataOperations metadataOperations;
    @Autowired
    private IMetadataIndexer metadataIndexer;

    public void onApplicationEvent(MetadataStatusChanged event) {
    }

    @TransactionalEventListener(phase=TransactionPhase.BEFORE_COMMIT)
    public void doBeforeCommit(MetadataStatusChanged event) {
        try {
            Log.trace((String)"geonetwork.datamanager", (Object)("Status changed for metadata with id " + event.getMd().getId()));
            StatusValue status = event.getStatus();
            switch (String.valueOf(status.getId())) {
                case "3": {
                    try {
                        ServiceContext context = ServiceContext.get();
                        Log.trace((String)"geonetwork.datamanager", (Object)("Unpublishing retired record (ID=" + event.getMd().getId() + ")."));
                        this.metadataOperations.forceUnsetOperation(context, event.getMd().getId(), ReservedGroup.all.getId(), ReservedOperation.download.getId());
                        this.metadataOperations.forceUnsetOperation(context, event.getMd().getId(), ReservedGroup.all.getId(), ReservedOperation.dynamic.getId());
                        this.metadataOperations.forceUnsetOperation(context, event.getMd().getId(), ReservedGroup.all.getId(), ReservedOperation.editing.getId());
                        this.metadataOperations.forceUnsetOperation(context, event.getMd().getId(), ReservedGroup.all.getId(), ReservedOperation.featured.getId());
                        this.metadataOperations.forceUnsetOperation(context, event.getMd().getId(), ReservedGroup.all.getId(), ReservedOperation.view.getId());
                        this.metadataOperations.forceUnsetOperation(context, event.getMd().getId(), ReservedGroup.all.getId(), ReservedOperation.notify.getId());
                        this.metadataIndexer.indexMetadata(Arrays.asList(String.valueOf(event.getMd().getId())));
                        break;
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.datamanager", (Object)"Error upgrading status", (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable e) {
            Log.error((String)"geonetwork.datamanager", (Object)("Error changing workflow status of " + event.getMd()), (Throwable)e);
        }
    }
}

