/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.serverlove.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.WellKnownImage;
import org.jclouds.elasticstack.suppliers.WellKnownImageSupplier;
import org.jclouds.json.Json;
import org.jclouds.location.Provider;
import org.jclouds.util.Strings2;

@Singleton
public class FixedWellKnownImageSupplier
implements WellKnownImageSupplier {
    private final Json json;
    private final String providerName;

    @Inject
    FixedWellKnownImageSupplier(Json json, @Provider String providerName) {
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
        this.providerName = (String)Preconditions.checkNotNull((Object)providerName, (Object)"providerName");
    }

    public List<WellKnownImage> get() {
        try {
            return (List)this.json.fromJson(Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/" + this.providerName + "/preinstalled_images.json")), new TypeLiteral<List<WellKnownImage>>(){}.getType());
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }
}

