/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain.page;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.page.PageIdentity;

@Entity(name="SPG_Page")
@Table(name="SPG_Page")
public class Page
extends GeonetEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PageIdentity pageIdentity;
    private byte[] data;
    private String link;
    private PageFormat format;
    private List<PageSection> sections;
    private PageStatus status;

    public Page() {
    }

    public Page(PageIdentity pageIdentity, byte[] data, String link, PageFormat format, List<PageSection> sections, PageStatus status) {
        this.pageIdentity = pageIdentity;
        this.data = data;
        this.link = link;
        this.format = format;
        this.sections = sections;
        this.status = status;
    }

    @EmbeddedId
    public PageIdentity getPageIdentity() {
        return this.pageIdentity;
    }

    @Column
    @Nullable
    @Lob
    @Basic(fetch=FetchType.LAZY)
    public byte[] getData() {
        return this.data;
    }

    @Column
    @Nullable
    @Basic(fetch=FetchType.LAZY)
    public String getLink() {
        return this.link;
    }

    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    public PageFormat getFormat() {
        return this.format;
    }

    @ElementCollection(targetClass=PageSection.class)
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="SPG_Sections")
    @Column(name="section")
    public List<PageSection> getSections() {
        return this.sections;
    }

    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    public PageStatus getStatus() {
        return this.status;
    }

    public void setPageIdentity(PageIdentity pageIdentity) {
        this.pageIdentity = pageIdentity;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setFormat(PageFormat format) {
        this.format = format;
    }

    public void setSections(List<PageSection> sections) {
        this.sections = sections;
    }

    public void setStatus(PageStatus status) {
        this.status = status;
    }

    public String toString() {
        return String.format("Entity of type %s with id: %s", this.getClass().getName(), this.getPageIdentity().getLinkText());
    }

    public static enum PageSection {
        ALL,
        TOP,
        FOOTER,
        MENU,
        SUBMENU,
        CUSTOM_MENU1,
        CUSTOM_MENU2,
        CUSTOM_MENU3,
        DRAFT;

    }

    public static enum PageFormat {
        LINK,
        HTML,
        TEXT,
        MARKDOWN,
        WIKI;

    }

    public static enum PageStatus {
        PUBLIC,
        PUBLIC_ONLY,
        PRIVATE,
        HIDDEN;

    }
}

