/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.security.GeneralSecurityException;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.signature.Signature;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.digest.Digest;
import net.schmizz.sshj.transport.kex.AbstractDH;
import net.schmizz.sshj.transport.kex.DHBase;
import net.schmizz.sshj.transport.kex.KeyExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDHG
extends AbstractDH
implements KeyExchange {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractDHG(DHBase dhBase, Digest digest) {
        super(dhBase, digest);
    }

    @Override
    public void init(Transport trans, String V_S, String V_C, byte[] I_S, byte[] I_C) throws GeneralSecurityException, TransportException {
        super.init(trans, V_S, V_C, I_S, I_C);
        this.digest.init();
        this.initDH(this.dh);
        this.log.debug("Sending SSH_MSG_KEXDH_INIT");
        trans.write((SSHPacket)new SSHPacket(Message.KEXDH_INIT).putBytes(this.dh.getE()));
    }

    @Override
    public boolean next(Message msg, SSHPacket packet) throws GeneralSecurityException, TransportException {
        byte[] sig;
        byte[] f;
        byte[] K_S;
        if (msg != Message.KEXDH_31) {
            throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "Unexpected packet: " + (Object)((Object)msg));
        }
        this.log.debug("Received SSH_MSG_KEXDH_REPLY");
        try {
            K_S = packet.readBytes();
            f = packet.readBytes();
            sig = packet.readBytes();
            this.hostKey = new Buffer.PlainBuffer(K_S).readPublicKey();
        }
        catch (Buffer.BufferException be) {
            throw new TransportException(be);
        }
        this.dh.computeK(f);
        Buffer.PlainBuffer buf = (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)this.initializedBuffer().putString(K_S)).putBytes(this.dh.getE())).putBytes(f)).putMPInt(this.dh.getK());
        this.digest.update(buf.array(), buf.rpos(), buf.available());
        this.H = this.digest.digest();
        Signature signature = (Signature)Factory.Named.Util.create(this.trans.getConfig().getSignatureFactories(), KeyType.fromKey(this.hostKey).toString());
        signature.init(this.hostKey, null);
        signature.update(this.H, 0, this.H.length);
        if (!signature.verify(sig)) {
            throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "KeyExchange signature verification failed");
        }
        return true;
    }

    protected abstract void initDH(DHBase var1) throws GeneralSecurityException;
}

