/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;
import java.util.Vector;

class RETokenRepeated
extends REToken {
    private REToken token;
    private int min;
    private int max;
    private boolean stingy;

    RETokenRepeated(int f_subIndex, REToken f_token, int f_min, int f_max) {
        super(f_subIndex);
        this.token = f_token;
        this.min = f_min;
        this.max = f_max;
    }

    void makeStingy() {
        this.stingy = true;
    }

    int getMinimumLength() {
        return this.min * this.token.getMinimumLength();
    }

    int[] match(CharIndexed input, int index, int eflags, REMatch mymatch) {
        int i;
        int numRepeats = 0;
        Vector<int[]> positions = new Vector<int[]>();
        int[] newIndex = new int[]{index};
        do {
            positions.addElement(newIndex);
            if (this.stingy && numRepeats >= this.min) {
                for (int i2 = 0; i2 < newIndex.length; ++i2) {
                    int[] s = this.next(input, newIndex[i2], eflags, mymatch);
                    if (s == null) continue;
                    return s;
                }
            }
            int[] doables = new int[]{};
            for (i = 0; i < newIndex.length; ++i) {
                int[] thisResult = this.token.match(input, newIndex[i], eflags, mymatch);
                if (thisResult == null) continue;
                int[] temp = new int[doables.length + thisResult.length];
                System.arraycopy(doables, 0, temp, 0, doables.length);
                for (int j = 0; j < thisResult.length; ++j) {
                    temp[doables.length + j] = thisResult[j];
                }
                doables = temp;
            }
            if (doables.length == 0) break;
            newIndex = doables;
        } while (numRepeats++ < this.max);
        if (numRepeats < this.min) {
            return null;
        }
        int posIndex = positions.size();
        while (--posIndex >= this.min) {
            newIndex = (int[])positions.elementAt(posIndex);
            for (i = 0; i < newIndex.length; ++i) {
                int[] doneIndex = this.next(input, newIndex[i], eflags, mymatch);
                if (doneIndex == null) continue;
                return doneIndex;
            }
        }
        return null;
    }

    void dump(StringBuffer os) {
        os.append('(');
        if (this.token.m_subIndex == 0) {
            os.append("?:");
        }
        this.token.dumpAll(os);
        os.append(')');
        if (this.max == Integer.MAX_VALUE && this.min <= 1) {
            os.append(this.min == 0 ? (char)'*' : '+');
        } else if (this.min == 0 && this.max == 1) {
            os.append('?');
        } else {
            os.append('{').append(this.min);
            if (this.max > this.min) {
                os.append(',');
                if (this.max != Integer.MAX_VALUE) {
                    os.append(this.max);
                }
            }
            os.append('}');
        }
        if (this.stingy) {
            os.append('?');
        }
    }
}

