/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.util.xml.ContextProvidingValidationEventHandler;
import org.hibernate.jpamodelgen.util.xml.JpaNamespaceTransformingEventReader;
import org.hibernate.jpamodelgen.util.xml.XmlParsingException;
import org.hibernate.jpamodelgen.xml.jaxb.ObjectFactory;
import org.xml.sax.SAXException;

public class XmlParserHelper {
    private static final String RESOURCE_PATH_SEPARATOR = "/";
    private static final int NUMBER_OF_SCHEMAS = 4;
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final ConcurrentMap<String, Schema> SCHEMA_CACHE = new ConcurrentHashMap<String, Schema>(4);
    private final Context context;

    public XmlParserHelper(Context context) {
        this.context = context;
    }

    public InputStream getInputStreamForResource(String resource) {
        InputStream ormStream;
        if (!resource.startsWith(RESOURCE_PATH_SEPARATOR)) {
            resource = RESOURCE_PATH_SEPARATOR + resource;
        }
        String pkg = this.getPackage(resource);
        String name = this.getRelativeName(resource);
        try {
            FileObject fileObject = this.context.getProcessingEnvironment().getFiler().getResource(StandardLocation.CLASS_OUTPUT, pkg, name);
            ormStream = fileObject.openInputStream();
        }
        catch (IOException e1) {
            ormStream = this.getClass().getResourceAsStream(resource);
        }
        return ormStream;
    }

    public Schema getSchema(String schemaResource) throws XmlParsingException {
        Schema schema = (Schema)SCHEMA_CACHE.get(schemaResource);
        if (schema != null) {
            return schema;
        }
        schema = this.loadSchema(schemaResource);
        Schema previous = SCHEMA_CACHE.putIfAbsent(schemaResource, schema);
        return previous != null ? previous : schema;
    }

    public <T> T getJaxbRoot(InputStream stream, Class<T> clazz, Schema schema) throws XmlParsingException {
        XMLEventReader staxEventReader;
        try {
            staxEventReader = this.createXmlEventReader(stream);
        }
        catch (XMLStreamException e) {
            throw new XmlParsingException("Unable to create stax reader", e);
        }
        ContextProvidingValidationEventHandler handler = new ContextProvidingValidationEventHandler();
        try {
            staxEventReader = new JpaNamespaceTransformingEventReader(staxEventReader);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)handler);
            return clazz.cast(unmarshaller.unmarshal(staxEventReader));
        }
        catch (JAXBException e) {
            StringBuilder builder = new StringBuilder();
            builder.append("Unable to perform unmarshalling at line number ");
            builder.append(handler.getLineNumber());
            builder.append(" and column ");
            builder.append(handler.getColumnNumber());
            builder.append(". Message: ");
            builder.append(handler.getMessage());
            throw new XmlParsingException(builder.toString(), e);
        }
    }

    private synchronized XMLEventReader createXmlEventReader(InputStream xmlStream) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLEventReader(xmlStream);
    }

    private String getPackage(String resourceName) {
        if (!resourceName.contains(RESOURCE_PATH_SEPARATOR)) {
            return "";
        }
        return resourceName.substring(0, resourceName.lastIndexOf(RESOURCE_PATH_SEPARATOR));
    }

    private String getRelativeName(String resourceName) {
        if (!resourceName.contains(RESOURCE_PATH_SEPARATOR)) {
            return resourceName;
        }
        return resourceName.substring(resourceName.lastIndexOf(RESOURCE_PATH_SEPARATOR) + 1);
    }

    private Schema loadSchema(String schemaName) throws XmlParsingException {
        Schema schema = null;
        URL schemaUrl = this.getClass().getClassLoader().getResource(schemaName);
        if (schemaUrl == null) {
            return schema;
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            throw new XmlParsingException("Unable to create schema for " + schemaName + ": " + e.getMessage(), e);
        }
        return schema;
    }
}

