/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.filter.LengthFunction;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FeatureTypeTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger(FeatureTypeTransformer.class);
    private static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";

    @Override
    public Translator createTranslator(ContentHandler handler) {
        FeatureTypeTranslator translator = new FeatureTypeTranslator(handler);
        return translator;
    }

    public static class FeatureTypeTranslator
    extends TransformerBase.TranslatorSupport {
        public FeatureTypeTranslator(ContentHandler handler) {
            super(handler, "xs", FeatureTypeTransformer.SCHEMA_NS);
        }

        @Override
        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof SimpleFeatureType)) {
                throw new IllegalArgumentException("Translator does not know how to translate " + o.getClass().getName());
            }
            this.encode((SimpleFeatureType)o);
        }

        protected void encode(SimpleFeatureType type) {
            List attributes = type.getAttributeDescriptors();
            try {
                this.startSchemaType(type.getTypeName(), type.getName().getNamespaceURI());
                for (int i = 0; i < attributes.size(); ++i) {
                    this.encode((AttributeDescriptor)attributes.get(i));
                }
                this.endSchemaType();
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        protected final void startSchemaType(String name, String namespace) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", name + "_Type");
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "complexType", "xs:complexType", atts);
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "complexContent", "xs:complexContent", new AttributesImpl());
            atts = new AttributesImpl();
            atts.addAttribute("", "base", "base", "", "gml:AbstractFeatureType");
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "extension", "xs:extension", atts);
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "sequence", "xs:sequence", new AttributesImpl());
        }

        protected void endSchemaType() throws SAXException {
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "sequence", "xs:sequence");
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "extension", "xs:extension");
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "complexContent", "xs:complexContent");
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "complexType", "xs:complexType");
        }

        protected void encode(AttributeDescriptor attribute) throws SAXException {
            Class type = attribute.getType().getBinding();
            if (Number.class.isAssignableFrom(type)) {
                this.encodeNumber(attribute);
            } else if (java.util.Date.class.isAssignableFrom(type)) {
                this.encodeDate(attribute);
            } else if (type == String.class) {
                this.encodeString(attribute);
            } else if (Geometry.class.isAssignableFrom(type)) {
                this.encodeGeometry(attribute);
            } else if (type == Boolean.class) {
                this.encodeBoolean(attribute);
            } else {
                throw new RuntimeException("Cannot encode " + type.getName());
            }
        }

        protected void encodeBoolean(AttributeDescriptor attribute) throws SAXException {
            AttributesImpl atts = this.createStandardAttributes(attribute);
            atts.addAttribute("", "type", "type", "", "xs:boolean");
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
        }

        protected void encodeString(AttributeDescriptor attribute) throws SAXException {
            int length = Integer.MAX_VALUE;
            for (Filter f : attribute.getType().getRestrictions()) {
                if (f == Filter.INCLUDE || f == Filter.EXCLUDE) continue;
                try {
                    if (!(f instanceof PropertyIsLessThan) && !(f instanceof PropertyIsLessThanOrEqualTo)) continue;
                    BinaryComparisonOperator cf = (BinaryComparisonOperator)f;
                    Expression e = cf.getExpression1();
                    if (e != null && e instanceof LengthFunction) {
                        length = Integer.parseInt(((Literal)cf.getExpression2()).getValue().toString());
                        continue;
                    }
                    if (!(cf.getExpression2() instanceof LengthFunction)) continue;
                    length = Integer.parseInt(((Literal)cf.getExpression1()).getValue().toString());
                }
                catch (Throwable t) {
                    length = Integer.MAX_VALUE;
                }
            }
            AttributesImpl atts = this.createStandardAttributes(attribute);
            if (length == 0) {
                atts.addAttribute("", "type", "type", "", "xs:string");
                this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
                this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
            } else {
                this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
                this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "simpleType", "xs:simpleType", new AttributesImpl());
                atts = new AttributesImpl();
                atts.addAttribute("", "base", "base", "", "xs:string");
                this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "restriction", "xs:restriction", atts);
                atts = new AttributesImpl();
                atts.addAttribute("", "value", "value", "", "" + length);
                this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "maxLength", "xs:maxLength", atts);
                this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "maxLength", "xs:maxLength");
                this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "restriction", "xs:restriction");
                this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "simpleType", "xs:simpleType");
                this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
            }
        }

        protected void encodeNumber(AttributeDescriptor attribute) throws SAXException {
            String typeString;
            AttributesImpl atts = this.createStandardAttributes(attribute);
            Class type = attribute.getType().getBinding();
            if (type == Byte.class) {
                typeString = "xs:byte";
            } else if (type == Short.class) {
                typeString = "xs:short";
            } else if (type == Integer.class) {
                typeString = "xs:int";
            } else if (type == Long.class) {
                typeString = "xs:long";
            } else if (type == Float.class) {
                typeString = "xs:float";
            } else if (type == Double.class) {
                typeString = "xs:double";
            } else if (type == BigInteger.class) {
                typeString = "xs:integer";
            } else if (type == BigDecimal.class) {
                typeString = "xs:decimal";
            } else if (Number.class.isAssignableFrom(type)) {
                typeString = "xs:decimal";
            } else {
                throw new RuntimeException("Called encode number with invalid attribute type.");
            }
            atts.addAttribute("", "type", "type", "", typeString);
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
        }

        protected void encodeDate(AttributeDescriptor attribute) throws SAXException {
            AttributesImpl atts = this.createStandardAttributes(attribute);
            Class binding = attribute.getType().getBinding();
            if (Date.class.isAssignableFrom(binding)) {
                atts.addAttribute("", "type", "type", "", "xs:date");
            } else if (Time.class.isAssignableFrom(binding)) {
                atts.addAttribute("", "type", "type", "", "xs:time");
            } else {
                atts.addAttribute("", "type", "type", "", "xs:dateTime");
            }
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
        }

        protected void encodeGeometry(AttributeDescriptor attribute) throws SAXException {
            AttributesImpl atts = this.createStandardAttributes(attribute);
            Class type = attribute.getType().getBinding();
            String typeString = "";
            LOGGER.finer(type.getName());
            if (type == Point.class) {
                typeString = "gml:PointPropertyType";
            } else if (type == LineString.class) {
                typeString = "gml:LineStringPropertyType";
            } else if (type == Polygon.class) {
                typeString = "gml:PolygonPropertyType";
            } else if (type == MultiPoint.class) {
                typeString = "gml:MultiPointPropertyType";
            } else if (type == MultiLineString.class) {
                typeString = "gml:MultiLineStringPropertyType";
            } else if (type == MultiPolygon.class) {
                typeString = "gml:MultiPolygonPropertyType";
            } else if (type == GeometryCollection.class) {
                typeString = "gml:MultiGeometryPropertyType";
            } else if (type == Geometry.class) {
                typeString = "gml:GeometryAssociationType";
            } else {
                throw new RuntimeException("Unsupported type: " + type.getName());
            }
            atts.addAttribute("", "type", "type", "", typeString);
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
        }

        protected AttributesImpl createStandardAttributes(AttributeDescriptor attribute) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", attribute.getLocalName());
            if (attribute.isNillable() && attribute.getMinOccurs() == 0) {
                atts.addAttribute("", "minOccurs", "minOccurs", "", "0");
                atts.addAttribute("", "nillable", "nillable", "", "true");
            } else {
                atts.addAttribute("", "minOccurs", "minOccurs", "", "1");
                atts.addAttribute("", "nillable", "nillable", "", "false");
            }
            return atts;
        }
    }
}

