/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.leveldb.record;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.MessageBuffer;
import org.fusesource.hawtbuf.proto.MessageBufferSupport;
import org.fusesource.hawtbuf.proto.PBMessage;
import org.fusesource.hawtbuf.proto.PBMessageFactory;
import org.fusesource.hawtbuf.proto.PBMessageFramedCodec;
import org.fusesource.hawtbuf.proto.PBMessageUnframedCodec;

public class CollectionRecord
implements PBMessageFactory<Bean, Buffer> {
    public static final CollectionRecord FACTORY = new CollectionRecord();
    public static final PBMessageFramedCodec<Buffer> FRAMED_CODEC = new PBMessageFramedCodec((PBMessageFactory)FACTORY);
    public static final PBMessageUnframedCodec<Buffer> UNFRAMED_CODEC = new PBMessageUnframedCodec((PBMessageFactory)FACTORY);

    public Bean create() {
        return new Bean();
    }

    public Bean parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return new Bean().mergeUnframed(data);
    }

    public Bean parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(new CodedInputStream(data));
    }

    public Buffer parseUnframed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        return new Buffer(data);
    }

    public Buffer parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseUnframed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        int length = data.readRawVarint32();
        int oldLimit = data.pushLimit(length);
        Buffer rc = this.parseUnframed(data.readRawBytes(length));
        data.popLimit(oldLimit);
        return rc;
    }

    public Buffer parseFramed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = new CodedInputStream(data);
            Buffer rc = this.parseFramed(input);
            input.checkLastTagWas(0);
            return rc;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
        }
    }

    public Buffer parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseFramed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(MessageBufferSupport.readFrame((InputStream)data));
    }

    public static final class Buffer
    implements MessageBuffer<Bean, Buffer>,
    Getter {
        private Bean bean;
        private org.fusesource.hawtbuf.Buffer buffer;
        private int size = -1;
        private int hashCode;

        private Buffer(org.fusesource.hawtbuf.Buffer buffer) {
            this.buffer = buffer;
        }

        private Buffer(Bean bean) {
            this.bean = bean;
        }

        @Override
        public Bean copy() {
            return this.bean().copy();
        }

        @Override
        public Buffer freeze() {
            return this;
        }

        private Bean bean() {
            if (this.bean == null) {
                try {
                    this.bean = new Bean().mergeUnframed(new CodedInputStream(this.buffer));
                    this.bean.frozen = this;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
                }
            }
            return this.bean;
        }

        public String toString() {
            return this.bean().toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            return this.bean().toString(sb, prefix);
        }

        @Override
        public boolean hasKey() {
            return this.bean().hasKey();
        }

        @Override
        public long getKey() {
            return this.bean().getKey();
        }

        @Override
        public boolean hasType() {
            return this.bean().hasType();
        }

        @Override
        public int getType() {
            return this.bean().getType();
        }

        @Override
        public boolean hasMeta() {
            return this.bean().hasMeta();
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getMeta() {
            return this.bean().getMeta();
        }

        public org.fusesource.hawtbuf.Buffer toUnframedBuffer() {
            if (this.buffer != null) {
                return this.buffer;
            }
            return MessageBufferSupport.toUnframedBuffer((MessageBuffer)this);
        }

        public org.fusesource.hawtbuf.Buffer toFramedBuffer() {
            return MessageBufferSupport.toFramedBuffer((MessageBuffer)this);
        }

        public byte[] toUnframedByteArray() {
            return this.toUnframedBuffer().toByteArray();
        }

        public byte[] toFramedByteArray() {
            return this.toFramedBuffer().toByteArray();
        }

        public void writeFramed(CodedOutputStream output) throws IOException {
            output.writeRawVarint32(this.serializedSizeUnframed());
            this.writeUnframed(output);
        }

        public void writeFramed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeFramed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeUnframed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(CodedOutputStream output) throws IOException {
            if (this.buffer == null) {
                int size2 = this.serializedSizeUnframed();
                this.buffer = output.getNextBuffer(size2);
                CodedOutputStream original = null;
                if (this.buffer == null) {
                    this.buffer = new org.fusesource.hawtbuf.Buffer(new byte[size2]);
                    original = output;
                    output = new CodedOutputStream(this.buffer);
                }
                if (this.bean.hasKey()) {
                    output.writeInt64(1, this.bean.getKey());
                }
                if (this.bean.hasType()) {
                    output.writeInt32(2, this.bean.getType());
                }
                if (this.bean.hasMeta()) {
                    output.writeBytes(3, this.bean.getMeta());
                }
                if (original != null) {
                    output.checkNoSpaceLeft();
                    output = original;
                    output.writeRawBytes(this.buffer);
                }
            } else {
                output.writeRawBytes(this.buffer);
            }
        }

        public int serializedSizeFramed() {
            int t = this.serializedSizeUnframed();
            return CodedOutputStream.computeRawVarint32Size((int)t) + t;
        }

        public int serializedSizeUnframed() {
            if (this.buffer != null) {
                return this.buffer.length;
            }
            if (this.size != -1) {
                return this.size;
            }
            this.size = 0;
            if (this.hasKey()) {
                this.size += CodedOutputStream.computeInt64Size((int)1, (long)this.getKey());
            }
            if (this.hasType()) {
                this.size += CodedOutputStream.computeInt32Size((int)2, (int)this.getType());
            }
            if (this.hasMeta()) {
                this.size += CodedOutputStream.computeBytesSize((int)3, (org.fusesource.hawtbuf.Buffer)this.getMeta());
            }
            return this.size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Buffer.class) {
                return false;
            }
            return this.equals((Buffer)obj);
        }

        public boolean equals(Buffer obj) {
            return this.toUnframedBuffer().equals(obj.toUnframedBuffer());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 0x77408060 ^ this.toUnframedBuffer().hashCode();
            }
            return this.hashCode;
        }

        public boolean frozen() {
            return true;
        }
    }

    public static final class Bean
    implements Getter {
        Buffer frozen;
        Bean bean;
        private long f_key = 0L;
        private boolean b_key;
        private int f_type = 0;
        private boolean b_type;
        private org.fusesource.hawtbuf.Buffer f_meta = null;

        public Bean() {
            this.bean = this;
        }

        public Bean(Bean copy) {
            this.bean = copy;
        }

        @Override
        public Bean copy() {
            return new Bean(this.bean);
        }

        public boolean frozen() {
            return this.frozen != null;
        }

        @Override
        public Buffer freeze() {
            if (this.frozen == null) {
                this.frozen = new Buffer(this.bean);
                assert (this.deepFreeze());
            }
            return this.frozen;
        }

        private boolean deepFreeze() {
            this.frozen.serializedSizeUnframed();
            return true;
        }

        private void copyCheck() {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            if (this.bean != this) {
                this.copy(this.bean);
            }
        }

        private void copy(Bean other) {
            this.bean = this;
            this.f_key = other.f_key;
            this.b_key = other.b_key;
            this.f_type = other.f_type;
            this.b_type = other.b_type;
            this.f_meta = other.f_meta;
        }

        @Override
        public boolean hasKey() {
            return this.bean.b_key;
        }

        @Override
        public long getKey() {
            return this.bean.f_key;
        }

        public Bean setKey(long key) {
            this.copyCheck();
            this.b_key = true;
            this.f_key = key;
            return this;
        }

        public void clearKey() {
            this.copyCheck();
            this.b_key = false;
            this.f_key = 0L;
        }

        @Override
        public boolean hasType() {
            return this.bean.b_type;
        }

        @Override
        public int getType() {
            return this.bean.f_type;
        }

        public Bean setType(int type) {
            this.copyCheck();
            this.b_type = true;
            this.f_type = type;
            return this;
        }

        public void clearType() {
            this.copyCheck();
            this.b_type = false;
            this.f_type = 0;
        }

        @Override
        public boolean hasMeta() {
            return this.bean.f_meta != null;
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getMeta() {
            return this.bean.f_meta;
        }

        public Bean setMeta(org.fusesource.hawtbuf.Buffer meta) {
            this.copyCheck();
            this.f_meta = meta;
            return this;
        }

        public void clearMeta() {
            this.copyCheck();
            this.f_meta = null;
        }

        public String toString() {
            return this.toString(new StringBuilder(), "").toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            if (this.hasKey()) {
                sb.append(prefix + "key: ");
                sb.append(this.getKey());
                sb.append("\n");
            }
            if (this.hasType()) {
                sb.append(prefix + "type: ");
                sb.append(this.getType());
                sb.append("\n");
            }
            if (this.hasMeta()) {
                sb.append(prefix + "meta: ");
                sb.append(this.getMeta());
                sb.append("\n");
            }
            return sb;
        }

        public Bean mergeUnframed(InputStream input) throws IOException {
            return this.mergeUnframed(new CodedInputStream(input));
        }

        public Bean mergeUnframed(CodedInputStream input) throws IOException {
            this.copyCheck();
            int tag;
            block6: while (((tag = input.readTag()) & 7) != 4) {
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        continue block6;
                    }
                    case 8: {
                        this.setKey(input.readInt64());
                        continue block6;
                    }
                    case 16: {
                        this.setType(input.readInt32());
                        continue block6;
                    }
                    case 26: 
                }
                this.setMeta(input.readBytes());
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Bean.class) {
                return false;
            }
            return this.equals((Bean)obj);
        }

        public boolean equals(Bean obj) {
            if (this.hasKey() ^ obj.hasKey()) {
                return false;
            }
            if (this.hasKey() && this.getKey() != obj.getKey()) {
                return false;
            }
            if (this.hasType() ^ obj.hasType()) {
                return false;
            }
            if (this.hasType() && this.getType() != obj.getType()) {
                return false;
            }
            if (this.hasMeta() ^ obj.hasMeta()) {
                return false;
            }
            return !this.hasMeta() || this.getMeta().equals(obj.getMeta());
        }

        public int hashCode() {
            int rc = 2066384;
            if (this.hasKey()) {
                rc ^= 0x1263F ^ new Long(this.getKey()).hashCode();
            }
            if (this.hasType()) {
                rc ^= 0x28035A ^ this.getType();
            }
            if (this.hasMeta()) {
                rc ^= 0x248A25 ^ this.getMeta().hashCode();
            }
            return rc;
        }

        public Bean mergeFrom(Getter other) {
            this.copyCheck();
            if (other.hasKey()) {
                this.setKey(other.getKey());
            }
            if (other.hasType()) {
                this.setType(other.getType());
            }
            if (other.hasMeta()) {
                this.setMeta(other.getMeta());
            }
            return this;
        }

        public void clear() {
            this.clearKey();
            this.clearType();
            this.clearMeta();
        }

        public void readExternal(DataInput in) throws IOException {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            this.bean = this;
            this.frozen = null;
            this.f_key = in.readLong();
            this.b_key = true;
            this.f_type = in.readInt();
            this.b_type = true;
            int size2 = in.readInt();
            if (size2 >= 0) {
                byte[] b = new byte[size2];
                in.readFully(b);
                this.f_meta = new org.fusesource.hawtbuf.Buffer(b);
            } else {
                this.f_meta = null;
            }
        }

        public void writeExternal(DataOutput out) throws IOException {
            out.writeLong(this.bean.f_key);
            out.writeInt(this.bean.f_type);
            if (this.bean.f_meta != null) {
                out.writeInt(this.bean.f_meta.getLength());
                out.write(this.bean.f_meta.getData(), this.bean.f_meta.getOffset(), this.bean.f_meta.getLength());
            } else {
                out.writeInt(-1);
            }
        }
    }

    public static interface Getter
    extends PBMessage<Bean, Buffer> {
        public boolean hasKey();

        public long getKey();

        public boolean hasType();

        public int getType();

        public boolean hasMeta();

        public org.fusesource.hawtbuf.Buffer getMeta();

        public Bean copy();

        public Buffer freeze();

        public StringBuilder toString(StringBuilder var1, String var2);
    }
}

